/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.junk.TARDISJunkControlListener;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FindWithJunkAction {
    private final TARDIS plugin;

    public FindWithJunkAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void getNearbyChunkLocation(int id, Player player) {
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        if (rst.fromUUID(player.getUniqueId().toString())) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, rst.getTardisId());
            if (rsc.resultSet() && rsc.getCurrent().location().getWorld() != null) {
                Chunk chunk = this.getRandomSurroundingChunk(rsc.getCurrent().location().getChunk());
                int x = TARDISConstants.RANDOM.nextInt(16) + chunk.getX() * 16;
                int z = TARDISConstants.RANDOM.nextInt(16) + chunk.getZ() * 16;
                Sign sign = TARDISJunkControlListener.getDestinationSign(id);
                sign.getSide(Side.FRONT).line(1, (Component)Component.text((String)chunk.getWorld().getName()));
                sign.getSide(Side.FRONT).line(2, (Component)Component.text((int)x));
                sign.getSide(Side.FRONT).line(3, (Component)Component.text((int)z));
                sign.update();
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXTERMINATE_NONE");
        }
    }

    private Chunk getRandomSurroundingChunk(Chunk chunk) {
        BlockFace face = this.plugin.getGeneralKeeper().getSurrounding().get(TARDISConstants.RANDOM.nextInt(this.plugin.getGeneralKeeper().getSurrounding().size()));
        Vector vector = face.getDirection();
        double cx = vector.getX() < 0.0 ? Math.floor(vector.getX()) : Math.ceil(vector.getX());
        double cz = vector.getZ() < 0.0 ? Math.floor(vector.getZ()) : Math.ceil(vector.getZ());
        int x = (int)((double)chunk.getX() + cx);
        int z = (int)((double)chunk.getZ() + cz);
        return chunk.getWorld().getChunkAt(x, z);
    }
}

