/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.TARDISSQLAlterEnergy;
import me.eccentric_nz.TARDIS.database.TARDISSQLCondenserUpdate;
import me.eccentric_nz.TARDIS.database.TARDISSQLDelete;
import me.eccentric_nz.TARDIS.database.TARDISSQLInsert;
import me.eccentric_nz.TARDIS.database.TARDISSQLInsertControl;
import me.eccentric_nz.TARDIS.database.TARDISSQLInsertLocations;
import me.eccentric_nz.TARDIS.database.TARDISSQLUpdate;
import me.eccentric_nz.TARDIS.database.TARDISSQLUpdateLocations;
import me.eccentric_nz.TARDIS.database.TARDISSQLUpsertSensor;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.tool.Table;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class QueryFactory {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;

    public QueryFactory(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void doInsert(String table, HashMap<String, Object> data) {
        TARDISSQLInsert insert = new TARDISSQLInsert(this.plugin, table, data);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSyncInsert(String table, HashMap<String, Object> data) {
        Statement ps = null;
        ResultSet idRS = null;
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbq = new StringBuilder();
        data.forEach((key, value) -> {
            sbf.append((String)key).append(",");
            sbq.append("?,");
        });
        String fields = sbf.substring(0, sbf.length() - 1);
        String questions = sbq.substring(0, sbq.length() - 1);
        try {
            this.service.testConnection(this.connection);
            String query = "INSERT INTO " + this.prefix + table + " (" + fields + ") VALUES (" + questions + ")";
            if (this.service.isMySQL()) {
                ps = this.connection.prepareStatement(query, 1);
            } else {
                String pKey = Table.valueOf(table).getRowId();
                ps = this.connection.prepareStatement(query + " RETURNING " + pKey);
            }
            int i = 1;
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                    ps.setString(i, entry.getValue().toString());
                } else if (entry.getValue() instanceof Integer) {
                    ps.setInt(i, (Integer)entry.getValue());
                } else if (entry.getValue() instanceof Double) {
                    ps.setDouble(i, (Double)entry.getValue());
                } else if (entry.getValue() instanceof Float) {
                    ps.setFloat(i, ((Float)entry.getValue()).floatValue());
                } else if (entry.getValue() instanceof Long) {
                    ps.setLong(i, (Long)entry.getValue());
                }
                ++i;
            }
            data.clear();
            if (this.service.isMySQL()) {
                ps.executeUpdate();
                idRS = ps.getGeneratedKeys();
            } else {
                idRS = ps.executeQuery();
            }
            int n = idRS.next() ? idRS.getInt(1) : -1;
            return n;
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for " + table + "! " + e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            try {
                if (idRS != null) {
                    idRS.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + table + "! " + e.getMessage());
            }
        }
    }

    public void doUpdate(String table, HashMap<String, Object> data, HashMap<String, Object> where) {
        TARDISSQLUpdate update = new TARDISSQLUpdate(this.plugin, table, data, where);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)update);
    }

    public void doSyncUpdate(String table, HashMap<String, Object> data, HashMap<String, Object> where) {
        TARDISSQLUpdate update = new TARDISSQLUpdate(this.plugin, table, data, where);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, (Runnable)update);
    }

    public void doDelete(String table, HashMap<String, Object> where) {
        TARDISSQLDelete delete = new TARDISSQLDelete(this.plugin, table, where);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSyncDelete(String table, HashMap<String, Object> where) {
        Statement statement = null;
        StringBuilder sbw = new StringBuilder();
        where.forEach((key, value) -> {
            sbw.append((String)key).append(" = ");
            if (value instanceof String || value instanceof UUID) {
                sbw.append("'").append(value).append("' AND ");
            } else {
                sbw.append(value).append(" AND ");
            }
        });
        where.clear();
        String values = sbw.substring(0, sbw.length() - 5);
        String query = "DELETE FROM " + this.prefix + table + " WHERE " + values;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            boolean bl = statement.executeUpdate(query) > 0;
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("Delete error for " + table + "! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + table + "! " + e.getMessage());
            }
        }
    }

    public void alterEnergyLevel(String table, int amount, HashMap<String, Object> where, Player p) {
        TARDISSQLAlterEnergy alter = new TARDISSQLAlterEnergy(this.plugin, table, amount, where, p);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)alter);
    }

    public void alterCondenserBlockCount(int amount, HashMap<String, Object> where) {
        TARDISSQLCondenserUpdate condense = new TARDISSQLCondenserUpdate(this.plugin, amount, where);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)condense);
    }

    public void upsertSensor(int id, String type, String location) {
        TARDISSQLUpsertSensor sensor = new TARDISSQLUpsertSensor(this.plugin, id, type, location);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)sensor);
    }

    public void insertControl(int id, int type, String location, int secondary) {
        TARDISSQLInsertControl control = new TARDISSQLInsertControl(this.plugin, id, type, location, secondary);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSyncControl(int id, int type, String location, int secondary) {
        Statement statement = null;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            String select = "SELECT c_id FROM " + this.prefix + "controls WHERE tardis_id = " + id + " AND type = " + type + " AND secondary = " + secondary;
            ResultSet rs = statement.executeQuery(select);
            if (rs.isBeforeFirst()) {
                rs.next();
                String update = "UPDATE " + this.prefix + "controls SET location = '" + location + "' WHERE c_id = " + rs.getInt("c_id");
                statement.executeUpdate(update);
            } else {
                String insert = "INSERT INTO " + this.prefix + "controls (tardis_id, type, location, secondary) VALUES (" + id + ", " + type + ", '" + location + "', " + secondary + ")";
                statement.executeUpdate(insert);
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Insert control error! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing insert control statement! " + e.getMessage());
            }
        }
    }

    public void insertLocations(HashMap<String, Object> data) {
        TARDISSQLInsertLocations locate = new TARDISSQLInsertLocations(this.plugin, data);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)locate);
    }

    public void updateLocations(HashMap<String, Object> data, int id) {
        TARDISSQLUpdateLocations locate = new TARDISSQLUpdateLocations(this.plugin, data, id);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)locate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCondensedBlockCount(int new_size, int id, String block_data) {
        Statement statement = null;
        String query = "UPDATE " + this.prefix + "condenser SET block_count = " + new_size + " WHERE tardis_id = " + id + " AND block_data = '" + block_data + "'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for condenser! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing condenser! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToVoid(int id) {
        Statement ps = null;
        String query = "INSERT INTO " + this.prefix + "thevoid (tardis_id) VALUES (?)";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for saving tardis_id to thevoid! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing thevoid statement! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean claimTARDIS(Player player, int id) {
        Statement ps = null;
        HashMap<String, Object> where = new HashMap<String, Object>();
        UUID uuid = player.getUniqueId();
        where.put("uuid", uuid);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            String query = "UPDATE " + this.prefix + "tardis SET uuid = ?, owner = ?, last_known_name = ?, abandoned = 0 , tardis_init = 1, powered_on = 1, lastuse = ? WHERE tardis_id = ?";
            try {
                boolean bool;
                this.service.testConnection(this.connection);
                long now = TARDISPermission.hasPermission(player, "tardis.prune.bypass") ? Long.MAX_VALUE - (long)TARDISConstants.RANDOM.nextInt(1000) : System.currentTimeMillis();
                ps = this.connection.prepareStatement(query);
                ps.setString(1, uuid.toString());
                ps.setString(2, player.getName());
                ps.setString(3, player.getName());
                ps.setLong(4, now);
                ps.setInt(5, id);
                boolean bl = bool = ps.executeUpdate() == 1;
                if (bool) {
                    query = "UPDATE " + this.prefix + "ars SET uuid = ? WHERE tardis_id = ?";
                    ps = this.connection.prepareStatement(query);
                    ps.setString(1, uuid.toString());
                    ps.setInt(2, id);
                    ps.executeUpdate();
                }
                boolean bl2 = bool;
                return bl2;
            }
            catch (SQLException e) {
                this.plugin.debug("Update error for claiming abandoned TARDIS! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing abandoned TARDIS claim statement! " + e.getMessage());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFarmingPref(UUID uuid, String room, int onOff) {
        Statement ps = null;
        String query = "UPDATE " + this.prefix + "farming_prefs SET " + room + " = ? WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, onOff);
            ps.setString(2, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for farming prefs! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing farming prefs! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMonsterIncrement(int id) {
        Statement ps = null;
        String query = "UPDATE " + this.prefix + "tardis SET monsters = monsters + 1 WHERE tardis_id = ?";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for tardis monsters +1! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis monsters +1! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAutonomousSaveUpdate(int old, int auto) {
        Statement ps = null;
        String first = "UPDATE " + this.prefix + "destinations SET autonomous = 0 WHERE dest_id = ?";
        String second = "UPDATE " + this.prefix + "destinations SET autonomous = 1 WHERE dest_id = ?";
        try {
            this.service.testConnection(this.connection);
            if (old != -1) {
                ps = this.connection.prepareStatement(first);
                ps.setInt(1, old);
                ps.executeUpdate();
            }
            ps = this.connection.prepareStatement(second);
            ps.setInt(1, auto);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for autonomous save! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing autonomous save! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEye(int id) {
        Statement ps = null;
        String query = "INSERT INTO " + this.prefix + "eyes (tardis_id) VALUES (?)";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for saving tardis_id to eyes! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing eyes statement! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegenerationCount(UUID uuid, int reduced) {
        Statement ps = null;
        String query = "UPDATE " + this.prefix + "player_prefs SET regenerations = ? WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, reduced);
            ps.setString(2, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for tardis regeneration -1! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis regeneration -1! " + e.getMessage());
            }
        }
    }
}

