/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

class TARDISSQLInsertLocations
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final HashMap<String, Object> data;
    private final String prefix;

    TARDISSQLInsertLocations(TARDIS plugin, HashMap<String, Object> data) {
        this.plugin = plugin;
        this.data = data;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] tables = new String[]{"homes", "current", "next", "back"};
        Statement ps = null;
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbq = new StringBuilder();
        this.data.forEach((key, value) -> {
            sbf.append((String)key).append(",");
            sbq.append("?,");
        });
        String fields = sbf.substring(0, sbf.length() - 1);
        String questions = sbq.substring(0, sbq.length() - 1);
        try {
            this.service.testConnection(this.connection);
            for (String s : tables) {
                ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + s + " (" + fields + ") VALUES (" + questions + ")");
                int i = 1;
                for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        ps.setString(i, entry.getValue().toString());
                    } else {
                        ps.setInt(i, (Integer)entry.getValue());
                    }
                    ++i;
                }
                ps.executeUpdate();
            }
            this.data.clear();
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for starting locations! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing location tables! " + e.getMessage());
            }
        }
    }
}

