/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISBindConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISBindConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Statement statement = null;
        Statement ps = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            String destinationQuery = "SELECT tardis_id, type, bind, dest_name, preset FROM " + this.prefix + "destinations WHERE bind != ''";
            String bindInsert = "INSERT INTO " + this.prefix + "bind (tardis_id, type, location, name) VALUES (?, ?, ?, ?)";
            ps = this.connection.prepareStatement(bindInsert);
            this.connection.setAutoCommit(false);
            ResultSet rsd = statement.executeQuery(destinationQuery);
            if (rsd.isBeforeFirst()) {
                while (rsd.next()) {
                    if (rsd.getInt("type") == 6) {
                        ps.setInt(1, rsd.getInt("tardis_id"));
                        ps.setInt(2, 6);
                        ps.setString(3, rsd.getString("bind"));
                        ps.setString(4, rsd.getString("preset"));
                        ps.addBatch();
                        ++i;
                    }
                    if (rsd.getInt("type") == 5) {
                        ps.setInt(1, rsd.getInt("tardis_id"));
                        ps.setInt(2, 5);
                        ps.setString(3, rsd.getString("bind"));
                        ps.setString(4, rsd.getString("preset").toUpperCase(Locale.ROOT));
                        ps.addBatch();
                        ++i;
                        continue;
                    }
                    ps.setInt(1, rsd.getInt("tardis_id"));
                    ps.setInt(2, rsd.getInt("type"));
                    ps.setString(3, rsd.getString("bind"));
                    ps.setString(4, rsd.getString("dest_name"));
                    ps.addBatch();
                    ++i;
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " old bind records");
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for destinations/bind tables (converting old bind records)! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing destinations/bind tables (converting old bind records)! " + e.getMessage());
            }
        }
    }
}

