/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import com.mojang.datafixers.util.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetAutonomousSave {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final ArrayList<Pair<String, Integer>> data = new ArrayList();
    private String autonomous = "";

    public ResultSetAutonomousSave(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromID(int id) {
        block19: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT dest_id, dest_name, autonomous FROM " + this.prefix + "destinations WHERE tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, id);
                rs = statement.executeQuery();
                String firstSave = "";
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        String name = rs.getString("dest_name");
                        if (firstSave.isEmpty()) {
                            firstSave = name;
                        }
                        this.data.add((Pair<String, Integer>)new Pair((Object)name, (Object)rs.getInt("dest_id")));
                        if (!rs.getBoolean("autonomous")) continue;
                        this.autonomous = name;
                    }
                    if (this.autonomous.isEmpty()) {
                        this.autonomous = firstSave;
                    }
                    break block19;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for autonomous destinations table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing autonomous destinations table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public String getAutonomous() {
        return this.autonomous;
    }

    public ArrayList<Pair<String, Integer>> getData() {
        return this.data;
    }
}

