/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.World;

public class ResultSetDeathLocation {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final String uuid;
    private World world;
    private int x;
    private int y;
    private int z;
    private COMPASS direction;
    private boolean submarine;

    public ResultSetDeathLocation(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block20: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "deaths WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.world = TARDISAliasResolver.getWorldFromAlias(rs.getString("world"));
                    if (this.world == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.x = rs.getInt("x");
                    this.y = rs.getInt("y");
                    this.z = rs.getInt("z");
                    this.direction = COMPASS.valueOf(rs.getString("direction"));
                    this.submarine = rs.getBoolean("submarine");
                    break block20;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for deaths table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing deaths table! " + e.getMessage());
                }
            }
        }
        return this.world != null;
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public COMPASS getDirection() {
        return this.direction;
    }

    public boolean isSubmarine() {
        return this.submarine;
    }
}

