/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ResultSetScreenText {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String prefix;
    private UUID uuid;

    public ResultSetScreenText(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    public void resultSetAsync(ResultSetOccupiedCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.resultSet();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSet() {
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT uuid FROM " + this.prefix + "interactions WHERE control = 'SCREEN' AND tardis_id = ?";
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    try {
                        this.uuid = UUID.fromString(rs.getString("uuid"));
                    }
                    catch (IllegalArgumentException e) {
                        this.uuid = TARDISStaticUtils.getZERO_UUID();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for ResultSetOccupiedScreen! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing ResultSetOccupiedScreen! " + e.getMessage());
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static interface ResultSetOccupiedCallback {
        public void onDone(ResultSetScreenText var1);
    }
}

