/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetSounds {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final List<UUID> data = new ArrayList<UUID>();
    private final String prefix;

    public ResultSetSounds(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block22: {
            Statement statement = null;
            Statement tardis = null;
            Statement travellers = null;
            ResultSet rs = null;
            ResultSet rsTARDIS = null;
            ResultSet rsTravellers = null;
            String queryTARDIS = "SELECT tardis_id, powered_on FROM " + this.prefix + "tardis WHERE tardis_id = ?";
            String queryTravellers = "SELECT uuid FROM " + this.prefix + "travellers WHERE tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.createStatement();
                tardis = this.connection.prepareStatement(queryTARDIS);
                travellers = this.connection.prepareStatement(queryTravellers);
                rs = statement.executeQuery("SELECT DISTINCT tardis_id FROM " + this.prefix + "travellers");
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        tardis.setInt(1, rs.getInt("tardis_id"));
                        rsTARDIS = tardis.executeQuery();
                        if (!rsTARDIS.next() || !rsTARDIS.getBoolean("powered_on")) continue;
                        travellers.setInt(1, rsTARDIS.getInt("tardis_id"));
                        rsTravellers = travellers.executeQuery();
                        while (rsTravellers.next()) {
                            this.data.add(UUID.fromString(rsTravellers.getString("uuid")));
                        }
                    }
                    break block22;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for travellers table [Sound]! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (rsTARDIS != null) {
                        rsTARDIS.close();
                    }
                    if (rsTravellers != null) {
                        rsTravellers.close();
                    }
                    if (tardis != null) {
                        tardis.close();
                    }
                    if (travellers != null) {
                        travellers.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing travellers table [Sound]! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<UUID> getData() {
        return Collections.unmodifiableList(this.data);
    }
}

