/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;

public class ResultSetThrottle {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetThrottle(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throticle getSpeedAndParticles(String uuid) {
        SpaceTimeThrottle throttle = SpaceTimeThrottle.NORMAL;
        boolean particles = false;
        Statement statement = null;
        ResultSet rs = null;
        String throttleQuery = "SELECT throttle FROM " + this.prefix + "player_prefs WHERE uuid = ?";
        String particleQuery = "SELECT particles_on FROM " + this.prefix + "particle_prefs WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(throttleQuery);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.next()) {
                throttle = SpaceTimeThrottle.getByDelay().get(rs.getInt("throttle"));
            }
            statement = this.connection.prepareStatement(particleQuery);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.next()) {
                particles = rs.getBoolean("particles_on");
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for throttle table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing throttle table! " + e.getMessage());
            }
        }
        return new Throticle(throttle, particles);
    }
}

