/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.outer;

import com.destroystokyo.paper.MaterialTags;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCompanions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorOpener;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFarmer;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFollowerSpawner;
import me.eccentric_nz.TARDIS.mobfarming.TARDISPetsAndFollowers;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.sonic.actions.TARDISSonicSound;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class OuterDisplayDoorAction
extends TARDISDoorListener {
    public OuterDisplayDoorAction(TARDIS plugin) {
        super(plugin);
    }

    public void processClick(int id, Player player, ArmorStand stand) {
        String model;
        ItemMeta dim;
        EntityEquipment ee = stand.getEquipment();
        ItemStack dye = ee.getHelmet();
        if (dye != null && (TARDISConstants.DYES.contains(dye.getType()) || this.plugin.getUtils().isCustomModel(dye)) && dye.hasItemMeta() && (dim = dye.getItemMeta()).hasItemModel() && ((model = dim.getItemModel().getKey()).contains("_open") || model.contains("_closed")) && TARDISPermission.hasPermission(player, "tardis.enter")) {
            UUID uuid = player.getUniqueId();
            Location location = stand.getLocation();
            String doorloc = TARDISStaticLocationGetters.makeLocationStr(location);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("door_location", doorloc);
            where.put("door_type", 0);
            ResultSetDoors rsd = new ResultSetDoors(this.plugin, where, false);
            if (rsd.resultSet()) {
                boolean closed = model.contains("_closed");
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().sendStatus(player, "SIEGE_NO_EXIT");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                    return;
                }
                HashMap<String, Object> tid = new HashMap<String, Object>();
                tid.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, tid, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    if (!tardis.isHandbrakeOn()) {
                        this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ENGAGE");
                        return;
                    }
                    ResultSetCompanions rsc = new ResultSetCompanions(this.plugin, id);
                    if (rsc.getCompanions().contains(uuid) || tardis.isAbandoned()) {
                        if (!rsd.isLocked()) {
                            Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                            if (closed) {
                                String key;
                                ResultSetPlayerPrefs rspref = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                                boolean willFarm = false;
                                boolean canPowerUp = false;
                                if (rspref.resultSet()) {
                                    key = !rspref.getKey().isEmpty() ? rspref.getKey() : this.plugin.getConfig().getString("preferences.key");
                                    willFarm = rspref.isFarmOn();
                                    if (rspref.isAutoPowerUp() && this.plugin.getConfig().getBoolean("allow.power_down")) {
                                        canPowerUp = !tardis.isAbandoned();
                                    }
                                } else {
                                    key = this.plugin.getConfig().getString("preferences.key");
                                }
                                Material m = Material.valueOf((String)key);
                                ItemStack hand = player.getInventory().getItemInMainHand();
                                if (hand.getType().equals((Object)m) || this.plugin.getConfig().getBoolean("preferences.any_key")) {
                                    if (player.isSneaking()) {
                                        TARDISDoorLocation idl = OuterDisplayDoorAction.getDoor(1, id);
                                        Location tardis_loc = idl.getL();
                                        World cw = idl.getW();
                                        COMPASS innerD = idl.getD();
                                        COMPASS d = rsd.getDoor_direction();
                                        COMPASS pd = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                                        World playerWorld = location.getWorld();
                                        TARDISPetsAndFollowers petsAndFollowers = null;
                                        if (this.plugin.getConfig().getBoolean("allow.mob_farming") && TARDISPermission.hasPermission(player, "tardis.farm") && !this.plugin.getTrackerKeeper().getFarming().contains(uuid) && willFarm) {
                                            this.plugin.getTrackerKeeper().getFarming().add(uuid);
                                            TARDISFarmer tf = new TARDISFarmer(this.plugin);
                                            petsAndFollowers = tf.farmAnimals(location, d, id, player.getPlayer(), tardis_loc.getWorld().getName(), playerWorld.getName());
                                        }
                                        if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && TARDISPermission.hasPermission(player, "tardis.skeletonkey")) {
                                            this.plugin.getWorldGuardUtils().addMemberToRegion(cw, tardis.getOwner(), player.getUniqueId());
                                        }
                                        cw.getChunkAt(tardis_loc).load();
                                        tardis_loc.setPitch(player.getLocation().getPitch());
                                        float yaw = player.getLocation().getYaw();
                                        if (!innerD.equals((Object)pd)) {
                                            yaw += this.adjustYaw(pd, innerD);
                                        }
                                        tardis_loc.setYaw(yaw);
                                        this.movePlayer(player, tardis_loc, false, playerWorld, rspref.isQuotesOn(), 1, rspref.isMinecartOn(), false);
                                        if (petsAndFollowers != null) {
                                            if (!petsAndFollowers.getPets().isEmpty()) {
                                                this.movePets(petsAndFollowers.getPets(), tardis_loc, player, d, true);
                                            }
                                            if (!petsAndFollowers.getFollowers().isEmpty()) {
                                                new TARDISFollowerSpawner(this.plugin).spawn(petsAndFollowers.getFollowers(), tardis_loc, player, d, true);
                                            }
                                        }
                                        if (canPowerUp && !tardis.isPoweredOn() && !tardis.isAbandoned()) {
                                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISPowerButton(this.plugin, id, player, tardis.getPreset(), false, tardis.isHidden(), tardis.isLightsOn(), player.getLocation(), tardis.getArtronLevel(), tardis.getSchematic().getLights()).clickButton(), 20L);
                                        }
                                        this.removeTraveller(uuid);
                                        HashMap<String, Object> set = new HashMap<String, Object>();
                                        set.put("tardis_id", id);
                                        set.put("uuid", uuid.toString());
                                        this.plugin.getQueryFactory().doSyncInsert("travellers", set);
                                    } else {
                                        new OuterDisplayDoorOpener(this.plugin).open(stand, id);
                                        if (innerDisplayDoor.display()) {
                                            new InnerDisplayDoorOpener(this.plugin).open(innerDisplayDoor.block(), id, true);
                                        } else {
                                            new InnerMinecraftDoorOpener(this.plugin).open(innerDisplayDoor.block(), id);
                                        }
                                    }
                                    TARDISSounds.playDoorSound(true, location);
                                } else if (TARDISStaticUtils.isSonic(hand) && MaterialTags.DYES.isTagged(dye.getType()) && tardis.getUuid().equals(uuid)) {
                                    ItemMeta im = hand.getItemMeta();
                                    List lore = im.lore();
                                    if (TARDISPermission.hasPermission(player, "tardis.sonic.paint") && lore != null && lore.contains(Component.text((String)"Painter Upgrade"))) {
                                        PlayerInventory inv = player.getInventory();
                                        ItemStack colour = inv.getItem(8);
                                        if (colour == null || !MaterialTags.DYES.isTagged(colour.getType())) {
                                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_DYE");
                                            return;
                                        }
                                        if (dye.getType() == colour.getType()) {
                                            return;
                                        }
                                        long now = System.currentTimeMillis();
                                        TARDISSonicSound.playSonicSound(this.plugin, player, now, 600L, "sonic_short");
                                        ItemStack sub = ItemStack.of((Material)colour.getType());
                                        sub.setItemMeta(colour.getItemMeta());
                                        ee.setHelmet(sub, true);
                                        int a = colour.getAmount();
                                        int a2 = a - 1;
                                        if (a2 > 0) {
                                            inv.getItem(8).setAmount(a2);
                                        } else {
                                            inv.setItem(8, null);
                                        }
                                        player.updateInventory();
                                        HashMap<String, Object> set = new HashMap<String, Object>();
                                        String c = "POLICE_BOX_" + colour.getType().toString().replace("_DYE", "");
                                        set.put("chameleon_preset", c);
                                        set.put("chameleon_demat", c);
                                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                                        wheret.put("tardis_id", tardis.getTardisId());
                                        this.plugin.getQueryFactory().doUpdate("tardis", set, wheret);
                                    }
                                }
                            } else {
                                if (tardis.isAbandoned()) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDONED_DOOR");
                                    return;
                                }
                                new OuterDisplayDoorCloser(this.plugin).close(stand, id, uuid);
                                if (innerDisplayDoor.display()) {
                                    new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid, true);
                                } else {
                                    new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid);
                                }
                            }
                        } else if (!tardis.getUuid().equals(uuid)) {
                            this.plugin.getMessenger().sendStatus(player, "DOOR_DEADLOCKED");
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DOOR_NEED_UNLOCK");
                        }
                    }
                }
            }
        }
    }
}

