/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.outer;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.utils.PandoricaOpens;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInnerDoorLocations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OuterDisplayDoorOpener {
    private final TARDIS plugin;

    public OuterDisplayDoorOpener(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void open(ArmorStand stand, int id) {
        block33: {
            if (stand == null) {
                return;
            }
            EntityEquipment ee = stand.getEquipment();
            ItemStack dye = ee.getHelmet();
            if (dye == null) {
                return;
            }
            if (!TARDISConstants.DYES.contains(dye.getType()) && !this.plugin.getUtils().isCustomModel(dye) || !dye.hasItemMeta()) break block33;
            ItemMeta dim = dye.getItemMeta();
            if (!dim.hasItemModel()) {
                return;
            }
            Location portal = new Location(stand.getWorld(), (double)stand.getLocation().getBlockX(), (double)stand.getLocation().getBlockY(), (double)stand.getLocation().getBlockZ());
            if (dye.getType() == Material.ENDER_PEARL) {
                new PandoricaOpens(this.plugin).animate(stand, true);
            } else {
                switch (dye.getType()) {
                    case CYAN_STAINED_GLASS_PANE: {
                        dim.setItemModel(ChameleonVariant.TENNANT_OPEN.getKey());
                        break;
                    }
                    case GRAY_STAINED_GLASS_PANE: {
                        dim.setItemModel(ChameleonVariant.WEEPING_ANGEL_OPEN.getKey());
                        break;
                    }
                    case WHITE_DYE: {
                        dim.setItemModel(ChameleonVariant.WHITE_OPEN.getKey());
                        break;
                    }
                    case ORANGE_DYE: {
                        dim.setItemModel(ChameleonVariant.ORANGE_OPEN.getKey());
                        break;
                    }
                    case MAGENTA_DYE: {
                        dim.setItemModel(ChameleonVariant.MAGENTA_OPEN.getKey());
                        break;
                    }
                    case LIGHT_BLUE_DYE: {
                        dim.setItemModel(ChameleonVariant.LIGHT_BLUE_OPEN.getKey());
                        break;
                    }
                    case YELLOW_DYE: {
                        dim.setItemModel(ChameleonVariant.YELLOW_OPEN.getKey());
                        break;
                    }
                    case LIME_DYE: {
                        dim.setItemModel(ChameleonVariant.LIME_OPEN.getKey());
                        break;
                    }
                    case PINK_DYE: {
                        dim.setItemModel(ChameleonVariant.PINK_OPEN.getKey());
                        break;
                    }
                    case GRAY_DYE: {
                        dim.setItemModel(ChameleonVariant.GRAY_OPEN.getKey());
                        break;
                    }
                    case LIGHT_GRAY_DYE: {
                        dim.setItemModel(ChameleonVariant.LIGHT_GRAY_OPEN.getKey());
                        break;
                    }
                    case CYAN_DYE: {
                        dim.setItemModel(ChameleonVariant.CYAN_OPEN.getKey());
                        break;
                    }
                    case PURPLE_DYE: {
                        dim.setItemModel(ChameleonVariant.PURPLE_OPEN.getKey());
                        break;
                    }
                    case BLUE_DYE: {
                        dim.setItemModel(ChameleonVariant.BLUE_OPEN.getKey());
                        break;
                    }
                    case BROWN_DYE: {
                        dim.setItemModel(ChameleonVariant.BROWN_OPEN.getKey());
                        break;
                    }
                    case GREEN_DYE: {
                        dim.setItemModel(ChameleonVariant.GREEN_OPEN.getKey());
                        break;
                    }
                    case RED_DYE: {
                        dim.setItemModel(ChameleonVariant.RED_OPEN.getKey());
                        break;
                    }
                    case BLACK_DYE: {
                        dim.setItemModel(ChameleonVariant.BLACK_OPEN.getKey());
                        break;
                    }
                    case LEATHER_HORSE_ARMOR: {
                        dim.setItemModel(ColouredVariant.TINTED_OPEN.getKey());
                        break;
                    }
                    default: {
                        NamespacedKey c = this.plugin.getUtils().getCustomModel(dye.getType(), "_open");
                        if (c == null) break;
                        dim.setItemModel(c);
                    }
                }
                dye.setItemMeta(dim);
                ee.setHelmet(dye, true);
                TARDISSounds.playDoorSound(true, portal);
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                ResultSetInnerDoorLocations resultSetPortal = new ResultSetInnerDoorLocations(this.plugin, id);
                if (resultSetPortal.resultSet()) {
                    Location teleport = resultSetPortal.getTeleportLocation();
                    TARDISTeleportLocation tp_in = new TARDISTeleportLocation();
                    tp_in.setLocation(teleport);
                    tp_in.setTardisId(id);
                    tp_in.setDirection(resultSetPortal.getDirection());
                    tp_in.setAbandoned(tardis.isAbandoned());
                    this.plugin.getTrackerKeeper().getPortals().put(portal, tp_in);
                    if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                        this.plugin.getTrackerKeeper().getMovers().add(tardis.getUuid());
                        if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                                this.plugin.getTrackerKeeper().getMovers().add(p.getUniqueId());
                            }
                        } else {
                            String[] companions;
                            for (String c : companions = tardis.getCompanions().split(":")) {
                                if (c.isEmpty()) continue;
                                this.plugin.getTrackerKeeper().getMovers().add(UUID.fromString(c));
                            }
                        }
                    }
                }
            }
        }
    }
}

