/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.outer;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.doors.DoorUtility;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;

public class OuterMinecraftDoorCloser {
    private final TARDIS plugin;

    public OuterMinecraftDoorCloser(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void close(Block block, int id, UUID uuid) {
        if (block != null && Tag.DOORS.isTagged((Keyed)block.getType())) {
            Openable closeable = (Openable)block.getBlockData();
            closeable.setOpen(false);
            block.setBlockData((BlockData)closeable, true);
        }
        if (this.plugin.getConfig().getBoolean("police_box.view_interior")) {
            this.plugin.getTrackerKeeper().getCasters().remove(uuid);
            if (this.plugin.getTrackerKeeper().getCastRestore().containsKey(uuid)) {
                for (Block b : this.plugin.getTrackerKeeper().getCastRestore().get(uuid)) {
                    b.getState().update();
                }
                this.plugin.getTrackerKeeper().getCastRestore().remove(uuid);
                if (this.plugin.getTrackerKeeper().getRotorRestore().containsKey(uuid)) {
                    int rotorId = this.plugin.getTrackerKeeper().getRotorRestore().get(uuid);
                    this.plugin.getTardisHelper().removeFakeItemFrame(rotorId, Bukkit.getPlayer((UUID)uuid));
                    this.plugin.getTrackerKeeper().getRotorRestore().remove(uuid);
                }
            }
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            TARDISTeleportLocation removed;
            Tardis tardis = rs.getTardis();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            rsc.resultSet();
            Location portal = rsc.getCurrent().location();
            if (tardis.getPreset().equals((Object)ChameleonPreset.SWAMP)) {
                portal.add(0.0, 1.0, 0.0);
            }
            if ((removed = this.plugin.getTrackerKeeper().getPortals().remove(portal)) == null) {
                DoorUtility.debugPortal(portal.toString());
            }
            if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                    for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                        this.plugin.getTrackerKeeper().getMovers().remove(p.getUniqueId());
                    }
                } else {
                    String[] companions;
                    for (String c : companions = tardis.getCompanions().split(":")) {
                        if (c.isEmpty()) continue;
                        this.plugin.getTrackerKeeper().getMovers().remove(UUID.fromString(c));
                    }
                    this.plugin.getTrackerKeeper().getMovers().remove(uuid);
                }
            }
        }
    }
}

