/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetFlightControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRepeaters;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.TARDISFlightAdjustment;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISManualFlightRunnable
implements Runnable {
    private static final int LOOPS = 10;
    private final TARDIS plugin;
    private final List<Location> target;
    private final List<String> controls = List.of("Helmic Regulator", "Astrosextant Rectifier", "Gravitic Anomaliser", "Absolute Tesseractulator");
    private final Player player;
    private final UUID uuid;
    private final boolean console;
    private int taskID;
    private int i = 0;

    TARDISManualFlightRunnable(TARDIS plugin, Player player, int id, boolean console) {
        this.plugin = plugin;
        this.player = player;
        this.target = this.getLocationList(id);
        this.uuid = player.getUniqueId();
        this.console = console;
        plugin.getTrackerKeeper().getManualFlightLocations().put(this.uuid, this.target);
    }

    @Override
    public void run() {
        this.plugin.getTrackerKeeper().getCount().put(this.uuid, 0);
        if (this.i < 10) {
            ++this.i;
            if (this.target == null || this.target.size() < 4) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "FLIGHT_BAD");
                return;
            }
            int r = TARDISConstants.RANDOM.nextInt(4);
            Location loc = this.target.get(r);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "FLIGHT_CLICK", this.controls.get(r));
            loc.getWorld().playEffect(loc, Effect.STEP_SOUND, 152);
            this.plugin.getTrackerKeeper().getFlight().put(this.player.getUniqueId(), loc.toString());
        } else {
            int blocks = 10 - this.plugin.getTrackerKeeper().getCount().get(this.player.getUniqueId());
            this.plugin.getServer().getScheduler().cancelTask(this.taskID);
            this.taskID = 0;
            this.plugin.getTrackerKeeper().getCount().remove(this.player.getUniqueId());
            this.plugin.getTrackerKeeper().getFlight().remove(this.uuid);
            if (blocks != 0) {
                Location adjusted = new TARDISFlightAdjustment(this.plugin).getLocation(this.plugin.getTrackerKeeper().getFlightData().get(this.uuid), blocks);
                this.plugin.getTrackerKeeper().getFlightData().get(this.uuid).setLocation(adjusted);
            }
            this.plugin.getTrackerKeeper().getManualFlightLocations().remove(this.uuid);
        }
    }

    private List<Location> getLocationList(int id) {
        if (this.console) {
            ResultSetFlightControls rsfc = new ResultSetFlightControls(this.plugin, id);
            if (rsfc.resultSet()) {
                return rsfc.getLocations();
            }
        } else {
            ResultSetRepeaters rsr = new ResultSetRepeaters(this.plugin, id, 0);
            if (rsr.resultSet()) {
                return rsr.getLocations();
            }
        }
        return null;
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }
}

