/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight.vehicle;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.flight.vehicle.TARDISArmourStand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class VehicleUtility {
    public static boolean isNotFlightReady(Location location) {
        for (Entity e : location.getWorld().getNearbyEntities(location, 1.5, 1.5, 1.5, s -> s.getType() == EntityType.ARMOR_STAND)) {
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand as = (ArmorStand)e;
            if (((CraftArmorStand)as).getHandle() instanceof TARDISArmourStand) {
                TARDIS.plugin.debug("Found TARDISArmourStand");
            } else {
                VehicleUtility.convertStand(as);
            }
            return false;
        }
        return true;
    }

    public static TARDISArmourStand spawnStand(Location location) {
        ServerLevel world = ((CraftWorld)location.getWorld()).getHandle();
        TARDISArmourStand entity = new TARDISArmourStand((net.minecraft.world.entity.EntityType<? extends net.minecraft.world.entity.decoration.ArmorStand>)net.minecraft.world.entity.EntityType.ARMOR_STAND, (Level)world);
        entity.setPosRaw(location.getX() + 0.5, location.getY(), location.getZ() + 0.5);
        world.addFreshEntity((net.minecraft.world.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entity;
    }

    public static void convertStand(Location location, ChameleonPreset preset, BuildData data) {
        ArmorStand old = null;
        for (Entity e : location.getWorld().getNearbyEntities(location, 1.5, 1.5, 1.5, s -> s.getType() == EntityType.ARMOR_STAND)) {
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand a = (ArmorStand)e;
            if (e instanceof TARDISArmourStand) continue;
            old = a;
        }
        if (old != null) {
            TARDISBuilderUtility.setPoliceBoxHelmet(TARDIS.plugin, preset, data, old);
            ArmorStand stand = VehicleUtility.convertStand(old);
            Interaction interaction = TARDISDisplayItemUtils.getInteraction(location);
            if (interaction != null) {
                interaction.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.INTEGER, (Object)data.getTardisID());
                interaction.getPersistentDataContainer().set(TARDIS.plugin.getStandUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)stand.getUniqueId());
            }
        }
    }

    public static ArmorStand convertStand(ArmorStand old) {
        Location location = old.getLocation();
        ServerLevel world = ((CraftWorld)location.getWorld()).getHandle();
        TARDISArmourStand entity = new TARDISArmourStand((net.minecraft.world.entity.EntityType<? extends net.minecraft.world.entity.decoration.ArmorStand>)net.minecraft.world.entity.EntityType.ARMOR_STAND, (Level)world);
        entity.setPosRaw((double)location.getBlockX() + 0.5, location.getY(), (double)location.getBlockZ() + 0.5);
        world.addFreshEntity((net.minecraft.world.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        ArmorStand stand = (ArmorStand)entity.getBukkitEntity();
        ItemStack is = old.getEquipment().getHelmet();
        stand.getEquipment().setHelmet(is, true);
        stand.setRotation(location.getYaw(), 0.0f);
        old.remove();
        return stand;
    }

    public static ItemDisplay getItemDisplay(Player player, ItemStack box, float scale) {
        ItemDisplay display = (ItemDisplay)player.getWorld().spawnEntity(player.getLocation().add(0.0, 1.5, 0.0), EntityType.ITEM_DISPLAY);
        display.setItemStack(box);
        Vector3f size = new Vector3f(scale, scale, scale);
        Vector3f position = new Vector3f(0.0f, -1.0f, 0.0f);
        Transformation initial = new Transformation(position, TARDISConstants.AXIS_ANGLE_ZERO, size, TARDISConstants.AXIS_ANGLE_ZERO);
        if (!player.getPassengers().isEmpty()) {
            ((Entity)player.getPassengers().getFirst()).remove();
        }
        player.addPassenger((Entity)display);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.NONE);
        display.setTransformation(initial);
        return display;
    }
}

