/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.TARDISStructureTravel;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.Structure;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateStructuresForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;
    private final Registry<Structure> structures = RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE);

    public FloodgateStructuresForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("Telepathic Structure Finder");
        for (Structure structure : TARDISStructureTravel.overworldStructures) {
            builder.button(TARDISStringUtils.capitalise(this.structures.getKey((Keyed)structure).getKey()), FormImage.Type.PATH, "textures/blocks/grass_side_carried.png");
        }
        for (Structure structure : TARDISStructureTravel.netherStructures) {
            builder.button(TARDISStringUtils.capitalise(this.structures.getKey((Keyed)structure).getKey()), FormImage.Type.PATH, "textures/blocks/crimson_nylium_side.png");
        }
        builder.button(TARDISStringUtils.capitalise(this.structures.getKey((Keyed)Structure.END_CITY).getKey()), FormImage.Type.PATH, "textures/blocks/purpur_block.png");
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        int travel;
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
        if (!rs.fromID(this.id)) {
            return;
        }
        int level = rs.getArtronLevel();
        if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
            return;
        }
        String enumStr = TARDISStringUtils.toEnumUppercase(response.clickedButton().text());
        player.performCommand("tardistravel structure " + enumStr);
    }
}

