/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.hads;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISCloisterBell
implements Runnable {
    private final TARDIS plugin;
    private final int loops;
    private final int id;
    private final Location centre;
    private final Location current;
    private final Player player;
    private final boolean messageOn;
    private final String reason;
    private final boolean messageOff;
    private int i = 0;
    private int task;

    public TARDISCloisterBell(TARDIS plugin, int loops, int id) {
        this.plugin = plugin;
        this.loops = loops;
        this.id = id;
        this.centre = this.getCentre(id);
        this.current = this.getCurrent(id);
        this.player = this.getPlayer(id);
        this.messageOn = false;
        this.messageOff = false;
        this.reason = "";
    }

    public TARDISCloisterBell(TARDIS plugin, int loops, int id, Player player) {
        this.plugin = plugin;
        this.loops = loops;
        this.id = id;
        this.centre = this.getCentre(id);
        this.current = this.getCurrent(id);
        this.player = player;
        this.messageOn = false;
        this.reason = "";
        this.messageOff = false;
    }

    TARDISCloisterBell(TARDIS plugin, int loops, int id, Location current, Player player, String reason) {
        this.plugin = plugin;
        this.loops = loops;
        this.id = id;
        this.centre = this.getCentre(id);
        this.current = current;
        this.player = player;
        this.messageOn = true;
        this.reason = reason;
        this.messageOff = true;
    }

    public TARDISCloisterBell(TARDIS plugin, int loops, int id, Location current, Player player, boolean messageOn, String reason, boolean messageOff) {
        this.plugin = plugin;
        this.loops = loops;
        this.id = id;
        this.centre = this.getCentre(id);
        this.current = current;
        this.player = player;
        this.messageOn = messageOn;
        this.reason = reason;
        this.messageOff = messageOff;
    }

    @Override
    public void run() {
        if (this.messageOn && this.i == 0 && this.player != null && this.player.isOnline()) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CLOISTER_BELL_ON", this.reason);
        }
        if (this.i < this.loops) {
            if (this.centre != null) {
                this.centre.getWorld().playSound(this.centre, "cloister_bell", 10.0f, 1.0f);
            }
            if (this.current != null) {
                this.current.getWorld().playSound(this.current, "cloister_bell", 2.0f, 1.0f);
            }
            if (this.player != null && this.player.isOnline()) {
                Location location = this.player.getLocation();
                if (!this.plugin.getUtils().inTARDISWorld(this.player) && !this.isInPoliceBoxRange(this.current, location)) {
                    location.getWorld().playSound(location, "cloister_bell", 1.0f, 1.0f);
                }
            }
            ++this.i;
        } else {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
            this.plugin.getTrackerKeeper().getCloisterBells().remove(this.id);
            if (this.messageOff && this.player != null && this.player.isOnline()) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CLOISTER_BELL_OFF");
            }
        }
    }

    public void setTask(int task) {
        this.task = task;
    }

    private Location getCentre(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            if (!tardis.getCreeper().isEmpty()) {
                return TARDISStaticLocationGetters.getLocationFromDB(tardis.getCreeper());
            }
            if (!tardis.getBeacon().isEmpty()) {
                return TARDISStaticLocationGetters.getLocationFromDB(tardis.getBeacon());
            }
        }
        return null;
    }

    private Location getCurrent(int id) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            return rsc.getCurrent().location();
        }
        return null;
    }

    private Player getPlayer(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            return this.plugin.getServer().getPlayer(rs.getTardis().getUuid());
        }
        return null;
    }

    private boolean isInPoliceBoxRange(Location current, Location location) {
        if (current.getWorld() != location.getWorld()) {
            return false;
        }
        int x = location.getBlockX();
        int z = location.getBlockZ();
        int minX = current.getBlockX() - 32;
        int maxX = current.getBlockX() + 32;
        int minZ = current.getBlockZ() - 32;
        int maxZ = current.getBlockZ() + 32;
        return x > minX && x < maxX && z > minZ && z < maxZ;
    }
}

