/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesBlock;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesCategory;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesProgramInventory;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesSavedInventory;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesValidator;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISHandlesProgramListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> scroll_start = new HashMap();
    private final HashMap<UUID, List<TARDISHandlesBlock>> scroll_list = new HashMap();
    private final HashMap<UUID, TARDISHandlesCategory> scroll_category = new HashMap();
    private final List<Material> allowed = List.of(Material.MUSIC_DISC_CHIRP, Material.MUSIC_DISC_WAIT, Material.MUSIC_DISC_CAT, Material.MUSIC_DISC_BLOCKS);

    public TARDISHandlesProgramListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onHandlesGUIClick(InventoryClickEvent event) {
        ItemStack item;
        int slot;
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TARDISHandlesProgramInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (!this.scroll_list.containsKey(uuid)) {
            this.scroll_list.put(uuid, TARDISHandlesBlock.getControls());
            this.scroll_category.put(uuid, TARDISHandlesCategory.CONTROL);
        }
        if ((slot = event.getRawSlot()) >= 0 && slot < 36 && !this.allowed.contains((item = player.getItemOnCursor()).getType())) {
            event.setCancelled(true);
        }
        if (slot < 0 || slot > 35 && slot < 54) {
            event.setCancelled(true);
        }
        switch (slot) {
            case 36: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getControls());
                this.setList(uuid, TARDISHandlesCategory.CONTROL, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 37: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getOperators());
                this.setList(uuid, TARDISHandlesCategory.OPERATOR, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 38: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getVariables());
                this.setList(uuid, TARDISHandlesCategory.VARIABLE, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 39: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getNumbers());
                this.setList(uuid, TARDISHandlesCategory.NUMBER, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 40: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getEvents());
                this.setList(uuid, TARDISHandlesCategory.EVENT, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 41: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getCommands());
                this.setList(uuid, TARDISHandlesCategory.COMMAND, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 42: {
                this.scroll_list.put(uuid, TARDISHandlesBlock.getSelectors());
                this.setList(uuid, TARDISHandlesCategory.SELECTOR, view);
                this.scroll_start.put(uuid, 0);
                break;
            }
            case 43: {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TARDISHandlesSavedInventory(this.plugin, uuid.toString()).getInventory()), 2L);
                break;
            }
            case 44: {
                int pid = this.saveDisk(view, uuid.toString(), player);
                if (pid != -1) {
                    this.close(player);
                    ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_WARD, (int)1);
                    ItemMeta im = is.getItemMeta();
                    im.displayName((Component)Component.text((String)"Handles Program Disk"));
                    im.lore(List.of(Component.text((String)"Untitled Disk"), Component.text((int)pid), Component.text((String)"Checked OUT")));
                    im.addItemFlags(ItemFlag.values());
                    is.setItemMeta(im);
                    player.getWorld().dropItemNaturally(player.getLocation(), is);
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "HANDLES_SAVED", "/tardishandles disk [name]", this.plugin);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HANDLES_NOTHING");
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                ItemStack is = view.getItem(slot);
                ItemStack cursor = player.getItemOnCursor();
                if (is == null || cursor.isSimilar(is)) {
                    player.setItemOnCursor(null);
                } else {
                    player.setItemOnCursor(is.clone());
                }
                if (is == null) break;
                is.setAmount(1);
                break;
            }
            case 52: {
                int startl;
                if (this.scroll_category.get(uuid).getSize() <= 7) break;
                int max = this.scroll_list.get(uuid).size() - 7;
                if (this.scroll_start.containsKey(uuid)) {
                    startl = this.scroll_start.get(uuid) + 1;
                    if (startl >= max) {
                        startl = max;
                    }
                } else {
                    startl = 1;
                }
                this.scroll_start.put(uuid, startl);
                for (int i = 0; i < 7; ++i) {
                    this.setSlot(view, 45 + i, this.scroll_list.get(uuid).get(startl + i));
                }
                break;
            }
            case 53: {
                int startr;
                if (this.scroll_category.get(uuid).getSize() <= 7) break;
                if (this.scroll_start.containsKey(uuid)) {
                    startr = this.scroll_start.get(uuid) - 1;
                    if (startr <= 0) {
                        startr = 0;
                    }
                } else {
                    startr = 0;
                }
                this.scroll_start.put(uuid, startr);
                for (int i = 0; i < 7; ++i) {
                    this.setSlot(view, 45 + i, this.scroll_list.get(uuid).get(startr + i));
                }
                break;
            }
            default: {
                item = player.getItemOnCursor();
                if (slot <= 53 || !item.getType().equals((Object)Material.PAPER)) break;
                event.setCancelled(true);
                player.setItemOnCursor(null);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHandlesProgramClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISHandlesProgramInventory)) {
            return;
        }
        Player p = (Player)event.getPlayer();
        ItemStack item = p.getItemOnCursor();
        if (item.getType().equals((Object)Material.PAPER)) {
            p.setItemOnCursor(null);
        }
    }

    private void setSlot(InventoryView view, int slot, TARDISHandlesBlock block) {
        ItemStack is = ItemStack.of((Material)Material.PAPER, (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)Component.text((String)block.getDisplayName()));
        if (block.getLore() != null) {
            im.lore(block.getLore());
        }
        is.setItemMeta(im);
        view.setItem(slot, is);
    }

    private void setList(UUID uuid, TARDISHandlesCategory category, InventoryView view) {
        this.scroll_category.put(uuid, category);
        for (int i = 0; i < 7; ++i) {
            if (i < category.getSize()) {
                this.setSlot(view, 45 + i, this.scroll_list.get(uuid).get(i));
                continue;
            }
            view.setItem(45 + i, null);
        }
    }

    private int saveDisk(InventoryView view, String uuid, Player player) {
        int pid = -1;
        ItemStack[] stack = new ItemStack[36];
        for (int i = 0; i < 36; ++i) {
            if (view.getItem(i) == null) continue;
            stack[i] = view.getItem(i);
            ++pid;
        }
        if (pid > 1) {
            TARDISHandlesValidator validator = new TARDISHandlesValidator(this.plugin, stack, player);
            if (validator.validateDisk()) {
                String serialized = TARDISSerializeInventory.itemStacksToString(stack);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("uuid", uuid);
                set.put("name", "Untitled Disk");
                set.put("inventory", serialized);
                set.put("checked", 1);
                pid = this.plugin.getQueryFactory().doSyncInsert("programs", set);
            } else {
                pid = -1;
            }
        }
        return pid;
    }

    private void close(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)p).closeInventory(), 1L);
    }
}

