/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonConstructor;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonTemplate;
import me.eccentric_nz.TARDIS.custommodels.GUILights;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISLightSequenceInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final Inventory inventory;

    public TARDISLightSequenceInventory(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 45, (Component)Component.text((String)"TARDIS Light Sequence", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stacks = new ItemStack[45];
        ItemStack lights = ItemStack.of((Material)GUILights.SEQUENCE_INFO.material(), (int)1);
        ItemMeta sim = lights.getItemMeta();
        sim.displayName((Component)Component.text((String)"TARDIS Light Sequence"));
        sim.lore(List.of(Component.text((String)"Click a block in"), Component.text((String)"the second row to"), Component.text((String)"change its colour.")));
        lights.setItemMeta(sim);
        stacks[GUILights.SEQUENCE_INFO.slot()] = lights;
        ResultSetLightPrefs rs = new ResultSetLightPrefs(this.plugin);
        if (rs.fromID(this.id)) {
            String[] sequence = rs.getSequence().split(":");
            for (int i = 9; i < 18; ++i) {
                ItemStack wool;
                Material material = Material.valueOf((String)(sequence[i - 9] + "_WOOL"));
                stacks[i] = wool = ItemStack.of((Material)material, (int)1);
            }
            String[] delays = rs.getDelays().split(":");
            for (int i = 18; i < 27; ++i) {
                int amount = TARDISNumberParsers.parseInt(delays[i - 18]);
                if (amount < 5) {
                    amount = 5;
                }
                ItemStack delay = ItemStack.of((Material)Material.COAL_BLOCK, (int)1);
                ItemMeta dim = delay.getItemMeta();
                dim.displayName((Component)Component.text((String)"Display time"));
                delay.setItemMeta(dim);
                delay.setAmount(amount);
                stacks[i] = delay;
            }
            String[] levels = rs.getLevels().split(":");
            for (int i = 27; i < 36; ++i) {
                int amount = TARDISNumberParsers.parseInt(levels[i - 27]);
                if (amount < 1) {
                    amount = 15;
                }
                ItemStack level = ItemStack.of((Material)Material.COAL_BLOCK, (int)1);
                ItemMeta lim = level.getItemMeta();
                lim.displayName((Component)Component.text((String)"Light level"));
                level.setItemMeta(lim);
                level.setAmount(amount);
                stacks[i] = level;
            }
        }
        ItemStack preset = ItemStack.of((Material)GUILights.BUTTON_LIGHT_SEQUENCE.material(), (int)1);
        ItemMeta pim = preset.getItemMeta();
        pim.displayName((Component)Component.text((String)"Preset Sequence"));
        pim.lore(List.of(Component.text((String)"Click to cycle through"), Component.text((String)"various light sequences."), Component.text((String)"1")));
        preset.setItemMeta(pim);
        stacks[36] = preset;
        ItemStack save = ItemStack.of((Material)GUIChameleonConstructor.SAVE_CONSTRUCT.material(), (int)1);
        ItemMeta se = save.getItemMeta();
        se.displayName((Component)Component.text((String)"Save Sequence"));
        save.setItemMeta(se);
        stacks[40] = save;
        ItemStack back = ItemStack.of((Material)GUIChameleonTemplate.BACK_HELP.material(), (int)1);
        ItemMeta bk = back.getItemMeta();
        bk.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(bk);
        stacks[42] = back;
        ItemStack close = ItemStack.of((Material)GUILights.CLOSE.material(), (int)1);
        ItemMeta clim = close.getItemMeta();
        clim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(clim);
        stacks[44] = close;
        return stacks;
    }
}

