/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class TARDISCreeperDeathListener
implements Listener {
    private final TARDIS plugin;

    public TARDISCreeperDeathListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCreeperDeath(EntityDeathEvent e) {
        Player p;
        Creeper c;
        LivingEntity ent = e.getEntity();
        if (ent instanceof Creeper && (c = (Creeper)ent).isPowered() && (p = c.getKiller()) != null) {
            String killerUUID = p.getUniqueId().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", killerUUID);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, killerUUID);
                HashMap<String, Object> set = new HashMap<String, Object>();
                int amount = this.plugin.getArtronConfig().getInt("creeper_recharge");
                if (!rsp.resultSet()) {
                    set.put("uuid", killerUUID);
                    set.put("artron_level", amount);
                    this.plugin.getQueryFactory().doInsert("player_prefs", set);
                } else {
                    int level = rsp.getArtronLevel() + amount;
                    HashMap<String, Object> wherea = new HashMap<String, Object>();
                    wherea.put("uuid", killerUUID);
                    set.put("artron_level", level);
                    this.plugin.getQueryFactory().doUpdate("player_prefs", set, wherea);
                }
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ENERGY_CREEPER", String.format("%d", amount));
                if (this.plugin.getAchievementConfig().getBoolean("kill.enabled")) {
                    TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, p, Advancement.KILL, 1);
                    taf.doAchievement(1);
                }
            }
        }
    }
}

