/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuildData;
import me.eccentric_nz.TARDIS.builders.utility.TARDISSeedBlockProcessor;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISSeedDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.VariableLight;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteractionCheck;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDISSeedBlockListener
implements Listener {
    private final TARDIS plugin;

    public TARDISSeedBlockListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSeedBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (!is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (!im.hasDisplayName() || !im.hasLore()) {
            return;
        }
        String dn = ComponentUtils.stripColour(im.displayName());
        if (dn.equals("TARDIS Seed Block")) {
            Block block = event.getBlockPlaced();
            if (im.getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.STRING)) {
                String key = (String)im.getPersistentDataContainer().get(this.plugin.getCustomBlockKey(), PersistentDataType.STRING);
                NamespacedKey which = new NamespacedKey((Plugin)this.plugin, key);
                block.setBlockData(TARDISConstants.BARRIER);
                TARDISDisplayItem tdi = TARDISDisplayItemRegistry.getByModel(which);
                if (tdi == null) {
                    tdi = TARDISSeedDisplayItem.CUSTOM;
                }
                TARDISDisplayItemUtils.setSeed(tdi, block, im);
            }
            List lore = im.lore();
            Schematic schm = Consoles.getBY_NAMES().get(ComponentUtils.stripColour((Component)lore.getFirst()));
            Material wall = Material.valueOf((String)TARDISStringUtils.getValuesFromWallString(ComponentUtils.stripColour((Component)lore.get(1))));
            Material floor = Material.valueOf((String)TARDISStringUtils.getValuesFromWallString(ComponentUtils.stripColour((Component)lore.get(2))));
            TARDISBuildData seed = new TARDISBuildData();
            seed.setSchematic(schm);
            seed.setWallType(wall);
            seed.setFloorType(floor);
            Location l = block.getLocation();
            this.plugin.getBuildKeeper().getTrackTARDISSeed().put(l, seed);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SEED_PLACE");
            if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(player.getUniqueId())) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.sendBlockChange(l, is.getType().createBlockData()), 3L);
            }
        } else if (dn.endsWith(" Console") && (is.getType().toString().endsWith("_CONCRETE") || is.getType() == Material.WAXED_OXIDIZED_COPPER)) {
            if (!this.plugin.getUtils().inTARDISWorld(player)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_IN_WORLD");
                event.setCancelled(true);
                return;
            }
            ResultSetInteractionCheck rsi = new ResultSetInteractionCheck(this.plugin);
            if (rsi.resultSetFromUUID(player.getUniqueId())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONSOLE_HAS");
                event.setCancelled(true);
                return;
            }
            String type = (String)im.getPersistentDataContainer().getOrDefault(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)"console_light_gray");
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            String uuid = player.getUniqueId().toString();
            if (rs.fromUUID(uuid)) {
                new ConsoleBuilder(this.plugin).create(event.getBlockPlaced(), type, rs.getTardisId(), uuid);
            }
        } else if (dn.endsWith("Variable Light") && is.getType() == Material.GLASS) {
            List lore = im.lore();
            Material variable = Material.valueOf((String)ComponentUtils.stripColour((Component)lore.getFirst()));
            new VariableLight(variable, event.getBlockPlaced().getLocation().add(0.5, 0.5, 0.5)).set();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSeedBlockBreak(BlockBreakEvent event) {
        Location l = event.getBlock().getLocation();
        Player p = event.getPlayer();
        if (this.plugin.getBuildKeeper().getTrackTARDISSeed().containsKey(l)) {
            if (!p.getGameMode().equals((Object)GameMode.CREATIVE)) {
                ItemStack is;
                TARDISBuildData data = this.plugin.getBuildKeeper().getTrackTARDISSeed().get(l);
                World w = l.getWorld();
                String console = data.getSchematic().getPermission().toUpperCase(Locale.ROOT);
                NamespacedKey model = TARDISSeedDisplayItem.CUSTOM.getCustomModel();
                if (data.getSchematic().isCustom()) {
                    is = ItemStack.of((Material)data.getSchematic().getSeedMaterial(), (int)1);
                } else {
                    try {
                        TARDISDisplayItem tdi = TARDISDisplayItemRegistry.valueOf(console);
                        is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
                        model = tdi.getCustomModel();
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                }
                ItemMeta im = is.getItemMeta();
                if (im == null) {
                    return;
                }
                im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)model.getKey());
                im.displayName((Component)ComponentUtils.toGold("TARDIS Seed Block"));
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                lore.add(Component.text((String)console));
                lore.add(Component.text((String)("Walls: " + data.getWallType().toString())));
                lore.add(Component.text((String)("Floors: " + data.getFloorType().toString())));
                im.lore(lore);
                is.setItemMeta(im);
                event.getBlock().setBlockData(TARDISConstants.AIR);
                w.dropItemNaturally(l, is);
            }
            this.plugin.getBuildKeeper().getTrackTARDISSeed().remove(l);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSeedInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (event.getClickedBlock() != null) {
            Location l = event.getClickedBlock().getLocation();
            if (this.plugin.getBuildKeeper().getTrackTARDISSeed().containsKey(l)) {
                Player player = event.getPlayer();
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                String key = rsp.resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key");
                if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.valueOf((String)key))) {
                    TARDISBuildData seed;
                    if (!this.plugin.getPlanetsConfig().getBoolean("planets." + l.getWorld().getName() + ".time_travel")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_NO_TARDIS");
                        return;
                    }
                    if (!this.plugin.getConfig().getString("creation.area", "none").equals("none")) {
                        String area = this.plugin.getConfig().getString("creation.area");
                        if (this.plugin.getTardisArea().areaCheckInExile(area, l)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_ONLY_AREA", area);
                            return;
                        }
                    }
                    if (new TARDISSeedBlockProcessor(this.plugin).processBlock(seed = this.plugin.getBuildKeeper().getTrackTARDISSeed().get(l), l, player)) {
                        this.plugin.getBuildKeeper().getTrackTARDISSeed().remove(l);
                        Block block = event.getClickedBlock();
                        TARDISDisplayItemUtils.remove(block);
                        block.setBlockData(TARDISConstants.BARRIER);
                        TARDISDisplayItemUtils.set(TARDISSeedDisplayItem.GROW, block, -1);
                        if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(player.getUniqueId())) {
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.sendBlockChange(l, Material.LIGHT_GRAY_TERRACOTTA.createBlockData()), 3L);
                        }
                    }
                }
            }
        }
    }
}

