/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.planets.WorldLoader;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISPlanetData;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISWorlds {
    private final TARDIS plugin;

    public TARDISWorlds(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void doWorlds() {
        List worlds = this.plugin.getServer().getWorlds();
        String defWorld = this.plugin.getConfig().getString("creation.default_world_name");
        worlds.forEach(w -> {
            String worldName = w.getName();
            if (!this.plugin.getPlanetsConfig().contains("planets." + worldName) && !worldName.equals(defWorld)) {
                TARDISPlanetData data = this.plugin.getTardisHelper().getLevelData(w.getName());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".enabled", (Object)false);
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".time_travel", (Object)(!TARDISConstants.isTARDISPlanet(worldName) ? 1 : 0));
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".resource_pack", (Object)"default");
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".gamemode", (Object)data.gameMode().toString());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".world_type", (Object)data.worldType().toString());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".environment", (Object)data.environment().toString());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".difficulty", (Object)data.difficulty().toString());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".generator", (Object)(worldName.startsWith("TARDIS_") || worldName.equals(this.plugin.getConfig().getString("creation.default_world_name")) ? "TARDISChunkGenerator" : "DEFAULT"));
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".spawn_chunk_radius", (Object)0);
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".alias", (Object)TARDISStringUtils.uppercaseFirst(worldName));
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".spawn_other_mobs", (Object)true);
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".gamerules", List.of());
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".allow_portals", (Object)true);
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".helmic_regulator_order", (Object)-1);
                this.plugin.getPlanetsConfig().set("planets." + worldName + ".icon", (Object)(switch (data.environment()) {
                    case World.Environment.NETHER -> "NETHERRACK";
                    case World.Environment.THE_END -> "END_STONE";
                    default -> "STONE";
                }));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added '" + worldName + "' to planets.yml. To exclude this world from time travel run: /tardisadmin exclude " + worldName);
            }
        });
        Set cWorlds = this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false);
        cWorlds.forEach(cw -> {
            if (TARDISAliasResolver.getWorldFromAlias(cw) == null) {
                if (this.worldFolderExists((String)cw) && this.plugin.getPlanetsConfig().getBoolean("planets." + cw + ".enabled")) {
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Attempting to load world: '" + cw + "'");
                    new WorldLoader(this.plugin).loadWorld((String)cw);
                    if (cw.equals("telos")) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            if (this.plugin.getPlanetsConfig().getBoolean("planets.telos.twilight")) {
                                World telos = this.plugin.getServer().getWorld("telos");
                                if (telos != null) {
                                    telos.setTime(13000L);
                                    telos.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                                    this.plugin.getPlanetsConfig().set("planets.telos.gamerules.doDaylightCycle", (Object)false);
                                }
                            } else {
                                this.plugin.getPlanetsConfig().set("planets.telos.gamerules.doDaylightCycle", (Object)true);
                            }
                            String planetsPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "planets.yml";
                            try {
                                this.plugin.getPlanetsConfig().save(new File(planetsPath));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }, 300L);
                    }
                }
            } else if (!(TARDISConstants.isTARDISPlanet(cw) || cw.equals("TARDIS_Zero_Room") || cw.equals("TARDIS_TimeVortex") || this.worldFolderExists((String)cw))) {
                this.plugin.getPlanetsConfig().set("planets." + cw, null);
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Removed '" + cw + "' from planets.yml");
                this.plugin.getCleanUpWorlds().add((String)cw);
            }
        });
        this.plugin.savePlanetsConfig();
    }

    private boolean worldFolderExists(String world) {
        String worldZero = ((World)this.plugin.getServer().getWorlds().getFirst()).getName();
        File container = this.plugin.getServer().getWorldContainer();
        File[] dirs = container.listFiles();
        if (dirs != null) {
            for (File dir : dirs) {
                File level;
                if (!dir.isDirectory()) continue;
                String name = dir.getName();
                if (name.startsWith(worldZero)) {
                    return true;
                }
                if (!name.equals(world) || !(level = new File(dir, "level.dat")).exists()) continue;
                return true;
            }
        }
        return false;
    }
}

