/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.eye;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class EyeStopper {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private Statement statement = null;
    private PreparedStatement ps = null;

    public EyeStopper(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ResultSet rs = null;
        try {
            String update = "UPDATE " + this.prefix + "eyes SET task = -1 WHERE eye_id = ?";
            this.ps = this.connection.prepareStatement(update);
            String query = "SELECT eye_id, task FROM " + this.prefix + "eyes";
            this.statement = this.connection.createStatement();
            rs = this.statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                this.connection.setAutoCommit(false);
                int count = 0;
                while (rs.next()) {
                    this.plugin.getServer().getScheduler().cancelTask(rs.getInt("task"));
                    this.ps.setInt(1, rs.getInt("eye_id"));
                    this.ps.addBatch();
                    ++count;
                }
                if (count > 0) {
                    this.ps.executeBatch();
                }
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Error stopping eye of harmony stars: " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing eye of harmony stars: " + ex.getMessage());
            }
        }
    }
}

