/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISCustomLightDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Lamp;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class TARDISLampsRunnable
implements Runnable {
    final Levelled levelled = TARDISConstants.LIGHT;
    private final TARDIS plugin;
    private final List<Lamp> lamps;
    private final long end;
    private final TardisLight light;
    private final boolean lights_on;
    private final int level;
    int i = 0;
    private int task;
    private Location handbrake_loc;

    TARDISLampsRunnable(TARDIS plugin, List<Lamp> lamps, long end, TardisLight light, boolean lights_on, int level) {
        this.plugin = plugin;
        this.lamps = lamps;
        this.end = end;
        this.light = light;
        this.lights_on = lights_on;
        this.level = level;
    }

    @Override
    public void run() {
        if (System.currentTimeMillis() > this.end) {
            this.lamps.forEach(l -> {
                Block b = l.block();
                ItemDisplay display = TARDISDisplayItemUtils.get(b);
                if (display != null) {
                    if (this.light.getCloister() == TARDISBlockDisplayItem.NONE) {
                        this.levelled.setLevel(this.lights_on ? Math.round((float)this.level * l.percentage()) : 0);
                        b.setBlockData((BlockData)this.levelled);
                    } else {
                        TARDISDisplayItem on = this.light.getOn();
                        TARDISDisplayItem off = this.light.getOff();
                        if (l.materialOn() != null) {
                            on = new TARDISCustomLightDisplayItem(l.materialOn(), true);
                        }
                        if (l.materialOff() != null) {
                            off = new TARDISCustomLightDisplayItem(l.materialOff(), false);
                        }
                        TARDISDisplayItem tdi = this.lights_on ? on : off;
                        ItemMeta im = display.getItemStack().getItemMeta();
                        im.setItemModel(tdi.getCustomModel());
                        ItemStack sub = ItemStack.of((Material)tdi.getMaterial());
                        sub.setItemMeta(im);
                        display.setItemStack(sub);
                    }
                }
            });
            this.plugin.getServer().getScheduler().cancelTask(this.task);
        } else {
            for (int j = 0; j < 9; ++j) {
                this.handbrake_loc.getWorld().playEffect(this.handbrake_loc, Effect.SMOKE, j);
            }
            this.lamps.forEach(l -> {
                Block b = l.block();
                if (this.i == 0 && (b.getType().equals((Object)Material.SEA_LANTERN) || b.getType().equals((Object)Material.REDSTONE_LAMP))) {
                    TARDISDisplayItemUtils.set(this.light.getCloister(), b, -1);
                } else {
                    ItemDisplay display = TARDISDisplayItemUtils.get(b);
                    if (display != null) {
                        TARDISDisplayItem tdi = this.light.getCloister();
                        if (this.i == 0 && tdi != TARDISBlockDisplayItem.NONE) {
                            ItemMeta im = display.getItemStack().getItemMeta();
                            im.setItemModel(tdi.getCustomModel());
                            ItemStack sub = ItemStack.of((Material)tdi.getMaterial());
                            sub.setItemMeta(im);
                            display.setItemStack(sub);
                        } else if (tdi == TARDISBlockDisplayItem.NONE) {
                            boolean off = this.i % 2 == 0;
                            this.levelled.setLevel(off ? 0 : this.level);
                            b.setBlockData((BlockData)this.levelled);
                        }
                    }
                }
            });
        }
        ++this.i;
    }

    public void setTask(int task) {
        this.task = task;
    }

    public void setHandbrake(Location handbrake_loc) {
        this.handbrake_loc = handbrake_loc;
    }
}

