/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.update;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Farm;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetFarming;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISUpdateableChecker {
    private final TARDIS plugin;
    private final Updateable updateable;
    private final Player player;
    private final Tardis tardis;
    private final String tardis_block;
    private final Set<Updateable> mustGrowRoom = Sets.newHashSet((Object[])new Updateable[]{Updateable.ALLAY, Updateable.BAMBOO, Updateable.BIRDCAGE, Updateable.FARM, Updateable.FUEL, Updateable.HAPPY, Updateable.HAPPY_GHAST_DOCK_LEVER, Updateable.HUTCH, Updateable.IGLOO, Updateable.IISTUBIL, Updateable.LAVA, Updateable.PEN, Updateable.SMELT, Updateable.STABLE, Updateable.STALL, Updateable.VAULT, Updateable.VILLAGE});

    public TARDISUpdateableChecker(TARDIS plugin, Updateable updateable, Player player, Tardis tardis, String tardis_block) {
        this.plugin = plugin;
        this.updateable = updateable;
        this.player = player;
        this.tardis = tardis;
        this.tardis_block = tardis_block;
    }

    public boolean canUpdate() {
        if (this.updateable.equals((Object)Updateable.SIEGE) && !this.plugin.getConfig().getBoolean("siege.enabled")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "SIEGE_DISABLED");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.BEACON) && !this.tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_BEACON");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.ADVANCED) && !TARDISPermission.hasPermission(this.player, "tardis.advanced")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_ADV");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.FORCEFIELD) && !TARDISPermission.hasPermission(this.player, "tardis.forcefield")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_FF");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.STORAGE) && !TARDISPermission.hasPermission(this.player, "tardis.storage")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_DISK");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.BACKDOOR) && !TARDISPermission.hasPermission(this.player, "tardis.backdoor")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_BACKDOOR");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.TEMPORAL) && !TARDISPermission.hasPermission(this.player, "tardis.temporal")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_TEMPORAL");
            return false;
        }
        boolean hasAllay = false;
        boolean hasBamboo = false;
        boolean hasBirdcage = false;
        boolean hasFarm = false;
        boolean hasHappy = false;
        boolean hasHutch = false;
        boolean hasIgloo = false;
        boolean hasIistubil = false;
        boolean hasLava = false;
        boolean hasPen = false;
        boolean hasSmelt = false;
        boolean hasStable = false;
        boolean hasStall = false;
        boolean hasVault = false;
        boolean hasVillage = false;
        if (this.mustGrowRoom.contains((Object)this.updateable)) {
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("tardis_id", this.tardis.getTardisId());
            ResultSetARS rsa = new ResultSetARS(this.plugin, wherea);
            if (rsa.resultSet()) {
                String[][][] json;
                String[][][] stringArray = json = TARDISARSMethods.getGridFromJSON(rsa.getJson());
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[][] level;
                    String[][] stringArray2 = level = stringArray[i];
                    int n2 = stringArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        String[] row;
                        String[] stringArray3 = row = stringArray2[j];
                        int n3 = stringArray3.length;
                        block36: for (int k = 0; k < n3; ++k) {
                            String col;
                            switch (col = stringArray3[k]) {
                                case "LIGHT_BLUE_CONCRETE": {
                                    hasAllay = true;
                                    continue block36;
                                }
                                case "BAMBOO": {
                                    hasBamboo = true;
                                    continue block36;
                                }
                                case "YELLOW_GLAZED_TERRACOTTA": {
                                    hasBirdcage = true;
                                    continue block36;
                                }
                                case "DIRT": {
                                    hasFarm = true;
                                    continue block36;
                                }
                                case "STRIPPED_OAK_LOG": {
                                    hasHappy = true;
                                    continue block36;
                                }
                                case "ACACIA_LOG": {
                                    hasHutch = true;
                                    continue block36;
                                }
                                case "PACKED_ICE": {
                                    hasIgloo = true;
                                    continue block36;
                                }
                                case "MOSS_BLOCK": {
                                    hasPen = true;
                                    continue block36;
                                }
                                case "WHITE_GLAZED_TERRACOTTA": {
                                    hasIistubil = true;
                                    continue block36;
                                }
                                case "MAGMA_BLOCK": {
                                    hasLava = true;
                                    continue block36;
                                }
                                case "CHEST": {
                                    hasSmelt = true;
                                    continue block36;
                                }
                                case "HAY_BLOCK": {
                                    hasStable = true;
                                    continue block36;
                                }
                                case "NETHER_WART_BLOCK": {
                                    hasStall = true;
                                    continue block36;
                                }
                                case "DISPENSER": {
                                    hasVault = true;
                                    continue block36;
                                }
                                case "OAK_LOG": {
                                    hasVillage = true;
                                    continue block36;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.updateable.equals((Object)Updateable.VAULT)) {
            if (!TARDISPermission.hasPermission(this.player, "tardis.vault")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_NO_PERM", "Vault room drop chest");
                return false;
            }
            if (!hasVault) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                return false;
            }
        }
        if (this.updateable.equals((Object)Updateable.FUEL) || this.updateable.equals((Object)Updateable.SMELT)) {
            if (!TARDISPermission.hasPermission(this.player, "tardis.room.smelter")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_NO_PERM", "Smelter room drop chest");
                return false;
            }
            if (!hasSmelt) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                return false;
            }
        }
        if (this.updateable.equals((Object)Updateable.FARM) || this.updateable.equals((Object)Updateable.IGLOO) || this.updateable.equals((Object)Updateable.STABLE) || this.updateable.equals((Object)Updateable.STALL) || this.updateable.equals((Object)Updateable.VILLAGE) || this.updateable.equals((Object)Updateable.IISTUBIL) || this.updateable.equals((Object)Updateable.HAPPY) || this.updateable.equals((Object)Updateable.HAPPY_GHAST_DOCK_LEVER) || this.updateable.equals((Object)Updateable.HUTCH) || this.updateable.equals((Object)Updateable.LAVA) || this.updateable.equals((Object)Updateable.PEN) || this.updateable.equals((Object)Updateable.BAMBOO) || this.updateable.equals((Object)Updateable.BIRDCAGE) || this.updateable.equals((Object)Updateable.ALLAY)) {
            if (!TARDISPermission.hasPermission(this.player, "tardis.farm")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_NO_PERM", this.tardis_block);
                return false;
            }
            ResultSetFarming rsf = new ResultSetFarming(this.plugin, this.tardis.getTardisId());
            if (rsf.resultSet()) {
                Farm farming = rsf.getFarming();
                if (this.updateable.equals((Object)Updateable.FARM) && farming.farm().isEmpty() && !hasFarm) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.ALLAY) && farming.allay().isEmpty() && !hasAllay) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.IGLOO) && farming.igloo().isEmpty() && !hasIgloo) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.IISTUBIL) && farming.iistubil().isEmpty() && !hasIistubil) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.LAVA) && farming.lava().isEmpty() && !hasLava) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.PEN) && farming.pen().isEmpty() && !hasPen) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if ((this.updateable.equals((Object)Updateable.HAPPY) || this.updateable.equals((Object)Updateable.HAPPY_GHAST_DOCK_LEVER)) && farming.happy().isEmpty() && !hasHappy) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.HUTCH) && farming.hutch().isEmpty() && !hasHutch) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.BAMBOO) && farming.bamboo().isEmpty() && !hasBamboo) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.BIRDCAGE) && farming.birdcage().isEmpty() && !hasBirdcage) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.STABLE) && farming.stable().isEmpty() && !hasStable) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.STALL) && farming.stall().isEmpty() && !hasStall) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
                if (this.updateable.equals((Object)Updateable.VILLAGE) && farming.village().isEmpty() && !hasVillage) {
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
                    return false;
                }
            }
        }
        if (this.updateable.equals((Object)Updateable.RAIL) && this.tardis.getRail().isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ROOM", this.tardis_block);
            return false;
        }
        if (this.updateable.equals((Object)Updateable.ZERO) && this.tardis.getZero().isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPDATE_ZERO");
            return false;
        }
        if (this.updateable.equals((Object)Updateable.ARS)) {
            if (!TARDISPermission.hasPermission(this.player, "tardis.architectural")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERM_ARS");
                return false;
            }
            if (!this.plugin.getUtils().canGrowRooms(this.tardis.getChunk())) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ARS_OWN_WORLD");
                return false;
            }
        }
        if (this.updateable.equals((Object)Updateable.WEATHER) && !TARDISPermission.hasPermission(this.player, "tardis.weather.clear") && !TARDISPermission.hasPermission(this.player, "tardis.weather.rain") && !TARDISPermission.hasPermission(this.player, "tardis.weather.thunder")) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_PERMS");
            return false;
        }
        if (!this.updateable.equals((Object)Updateable.BACKDOOR)) {
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", this.player.getUniqueId().toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
            if (!rst.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NOT_IN_TARDIS");
                return false;
            }
            int thisid = rst.getTardis_id();
            if (thisid != this.tardis.getTardisId()) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CMD_ONLY_TL");
                return false;
            }
        }
        return true;
    }
}

