/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCount;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.display.TARDISDisplayType;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischunkgenerator.worldgen.TARDISChunkGenerator;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TARDISUtils {
    private final TARDIS plugin;
    private final String[] CARDINAL = new String[]{"E", "NE", "N", "NW", "W", "SW", "S", "SE"};

    public TARDISUtils(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean compareLocations(Location a, Location b) {
        if (a.getWorld().equals((Object)b.getWorld())) {
            double rd = this.plugin.getArtronConfig().getDouble("recharge_distance");
            double squared = rd * rd;
            return a.distanceSquared(b) <= squared;
        }
        return false;
    }

    public boolean canGrowRooms(String chunk) {
        String[] data = chunk.split(":");
        World room_world = TARDISStaticLocationGetters.getWorldFromSplitString(chunk);
        ChunkGenerator gen = room_world.getGenerator();
        String dn = "TARDIS_TimeVortex";
        if (this.plugin.getConfig().getBoolean("creation.default_world")) {
            dn = this.plugin.getConfig().getString("creation.default_world_name");
        }
        boolean special = data[0].equalsIgnoreCase(dn) && gen instanceof TARDISChunkGenerator;
        return data[0].contains("TARDIS_WORLD_") || special;
    }

    public boolean inTARDISWorld(Player player) {
        World world = (World)this.plugin.getServer().getWorlds().getFirst();
        String name = "";
        if (player != null && player.isOnline()) {
            world = player.getLocation().getWorld();
            name = world.getName();
        }
        ChunkGenerator gen = world.getGenerator();
        String dn = "TARDIS_TimeVortex";
        if (this.plugin.getConfig().getBoolean("creation.default_world")) {
            dn = this.plugin.getConfig().getString("creation.default_world_name");
        }
        boolean special = (name.equals(dn) || name.equals("TARDIS_Zero_Room")) && gen instanceof TARDISChunkGenerator;
        return name.equals("TARDIS_WORLD_" + player.getName()) || special;
    }

    public boolean inTARDISWorld(Location loc) {
        World world = loc.getWorld();
        String name = world.getName();
        ChunkGenerator gen = world.getGenerator();
        String dn = "TARDIS_TimeVortex";
        if (this.plugin.getConfig().getBoolean("creation.default_world")) {
            dn = this.plugin.getConfig().getString("creation.default_world_name");
        }
        boolean special = name.equals(dn) && gen instanceof TARDISChunkGenerator;
        return name.startsWith("TARDIS_WORLD_") || special;
    }

    public void updateStorageId(String uuid, int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetDiskStorage rss = new ResultSetDiskStorage(this.plugin, where);
        if (rss.resultSet()) {
            HashMap<String, Object> wherej = new HashMap<String, Object>();
            wherej.put("uuid", uuid);
            HashMap<String, Object> setj = new HashMap<String, Object>();
            setj.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("storage", setj, wherej);
        }
    }

    public NamedTextColor getSignColour() {
        NamedTextColor colour;
        String cc = this.plugin.getConfig().getString("police_box.sign_colour", "WHITE");
        try {
            colour = (NamedTextColor)NamedTextColor.NAMES.value((Object)cc);
        }
        catch (IllegalArgumentException e) {
            colour = NamedTextColor.WHITE;
        }
        return colour;
    }

    public int getHighestNetherBlock(World w, int wherex, int wherez) {
        int y = 100;
        Block startBlock = w.getBlockAt(wherex, y, wherez);
        while (!startBlock.getType().isAir()) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
        }
        int air = 0;
        while (startBlock.getType().isAir() && startBlock.getLocation().getBlockY() > 30) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
            ++air;
        }
        Material mat = startBlock.getType();
        if (air >= 4 && (this.plugin.getGeneralKeeper().getGoodNether().contains(mat) || this.plugin.getPlanetsConfig().getBoolean("planets." + w.getName() + ".false_nether"))) {
            y = startBlock.getLocation().getBlockY() + 1;
        }
        return y;
    }

    public boolean inGracePeriod(Player p, boolean update) {
        int grace_count;
        ResultSetCount rsc;
        boolean inGracePeriod = false;
        int grace = this.plugin.getConfig().getInt("travel.grace_period");
        if (grace > 0 && (rsc = new ResultSetCount(this.plugin, p.getUniqueId().toString())).resultSet() && (grace_count = rsc.getGrace()) < grace) {
            inGracePeriod = true;
            if (update) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "GRACE_PERIOD", String.format("%d", grace - (grace_count + 1)));
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", p.getUniqueId().toString());
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("grace", grace_count + 1);
                this.plugin.getQueryFactory().doUpdate("t_count", set, where);
            }
        }
        return inGracePeriod;
    }

    public List<Entity> getJunkTravellers(Location loc) {
        Entity orb = loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
        List ents = orb.getNearbyEntities(16.0, 16.0, 16.0);
        orb.remove();
        return ents;
    }

    private String getFacingXZ(Player player) {
        if (player.getFacing() == BlockFace.NORTH) {
            return "-Z";
        }
        if (player.getFacing() == BlockFace.SOUTH) {
            return "+Z";
        }
        if (player.getFacing() == BlockFace.EAST) {
            return "+X";
        }
        if (player.getFacing() == BlockFace.WEST) {
            return "-X";
        }
        return "Error!";
    }

    public String getFacing(Player player) {
        double yaw = player.getLocation().getYaw();
        if (yaw >= 337.5 || yaw <= 22.5 && yaw >= 0.0 || yaw >= -22.5 && yaw <= 0.0 || yaw <= -337.5 && yaw <= 0.0) {
            return "S";
        }
        if (yaw >= 22.5 && yaw <= 67.5 || yaw <= -292.5 && yaw >= -337.5) {
            return "SW";
        }
        if (yaw >= 67.5 && yaw <= 112.5 || yaw <= -247.5 && yaw >= -292.5) {
            return "W";
        }
        if (yaw >= 112.5 && yaw <= 157.5 || yaw <= -202.5 && yaw >= -247.5) {
            return "NW";
        }
        if (yaw >= 157.5 && yaw <= 202.5 || yaw <= -157.5 && yaw >= -202.5) {
            return "N";
        }
        if (yaw >= 202.5 && yaw <= 247.5 || yaw <= -112.5 && yaw >= -157.5) {
            return "NE";
        }
        if (yaw >= 247.5 && yaw <= 292.5 || yaw <= -67.5 && yaw >= -112.5) {
            return "E";
        }
        if (yaw >= 292.5 && yaw <= 337.5 || yaw <= -22.5 && yaw >= -67.5) {
            return "SE";
        }
        return "Error!";
    }

    public String actionBarFormat(Player player) {
        TARDISDisplayType displayType = this.plugin.getTrackerKeeper().getDisplay().get(player.getUniqueId());
        return switch (displayType) {
            case TARDISDisplayType.BIOME -> displayType.getFormat().replace("%BIOME%", player.getLocation().getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT));
            case TARDISDisplayType.COORDS -> displayType.getFormat().replace("%X%", String.format("%,d", player.getLocation().getBlockX())).replace("%Y%", String.format("%,d", player.getLocation().getBlockY())).replace("%Z%", String.format("%,d", player.getLocation().getBlockZ()));
            case TARDISDisplayType.DIRECTION -> displayType.getFormat().replace("%FACING%", this.getFacing(player)).replace("%FACING_XZ%", this.getFacingXZ(player));
            case TARDISDisplayType.LOCATOR -> displayType.getFormat().replace("%DIRECTIONS%", this.getDirection(player));
            case TARDISDisplayType.TARGET_BLOCK -> displayType.getFormat().replace("%TARGET_BLOCK%", player.getTargetBlock(null, 5).getType().toString());
            case TARDISDisplayType.WORLD -> displayType.getFormat().replace("%WORLD%", player.getLocation().getWorld().getName());
            default -> this.plugin.getConfig().getString("display.all", "&6X&7%X% &6Y&7%Y% &6Z&7%Z% &6F&7%FACING% (%FACING_XZ%) %TARGET_BLOCK%").replace("%WORLD%", player.getLocation().getWorld().getName()).replace("%X%", String.format("%,d", player.getLocation().getBlockX())).replace("%Y%", String.format("%,d", player.getLocation().getBlockY())).replace("%Z%", String.format("%,d", player.getLocation().getBlockZ())).replace("%FACING%", this.getFacing(player)).replace("%FACING_XZ%", this.getFacingXZ(player)).replace("%YAW%", String.format("%.1f", Float.valueOf(player.getLocation().getYaw()))).replace("%PITCH%", String.format("%.1f", Float.valueOf(player.getLocation().getPitch()))).replace("%BIOME%", player.getLocation().getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT)).replace("%TARGET_BLOCK%", player.getTargetBlock(null, 5).getType().toString());
        };
    }

    private String getDirection(Player player) {
        Location location = player.getLocation();
        Location tardis = this.plugin.getTrackerKeeper().getLocators().get(player.getUniqueId());
        if (location.getWorld() != tardis.getWorld()) {
            return "TARDIS is located in " + tardis.getWorld().getName();
        }
        Vector playerToEntity = tardis.clone().subtract(location).toVector();
        Vector playerLooking = location.getDirection();
        double x1 = playerToEntity.getX();
        double z1 = playerToEntity.getZ();
        double x2 = playerLooking.getX();
        double z2 = playerLooking.getZ();
        double turn = Math.atan2(x1 * z2 - z1 * x2, x1 * x2 + z1 * z2) * 180.0 / Math.PI;
        int compass = ((int)Math.round(Math.atan2(location.getX() - tardis.getX(), location.getZ() - tardis.getZ()) / 0.7853981633974483) + 8) % 8;
        String d = this.CARDINAL[compass];
        int distance = this.getHorizontalDistance(location, tardis);
        if (turn >= -22.5 && turn < 22.55) {
            return "\u2191 " + distance + " blocks " + d;
        }
        if (turn >= 22.5 && turn < 67.5) {
            return "\u2196 " + distance + " blocks " + d;
        }
        if (turn >= 67.5 && turn < 112.5) {
            return "\u2190 " + distance + " blocks " + d;
        }
        if (turn >= 112.5 && turn <= 157.5) {
            return "\u2199 " + distance + " blocks " + d;
        }
        if (turn >= 157.5 && turn <= 180.0 || turn >= -180.0 && turn < -157.5) {
            return "\u2193 " + distance + " blocks " + d;
        }
        if (turn >= -157.5 && turn < -112.5) {
            return "\u2198 " + distance + " blocks " + d;
        }
        if (turn >= -112.5 && turn < -67.5) {
            return "\u2192 " + distance + " blocks " + d;
        }
        if (turn >= -67.5 && turn < -22.5) {
            return "\u2197 " + distance + " blocks " + d;
        }
        return d;
    }

    public int getHorizontalDistance(Location first, Location second) {
        double fx = first.getX();
        double fz = first.getZ();
        double sx = second.getX();
        double sz = second.getZ();
        return (int)Math.sqrt(Math.pow(fx - sx, 2.0) + Math.pow(fz - sz, 2.0));
    }

    public boolean isCustomModel(ItemStack is) {
        for (String k : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            if (!this.plugin.getCustomModelConfig().getString("models." + k + ".item").equals(is.getType().toString())) continue;
            return true;
        }
        return false;
    }

    public NamespacedKey getCustomModel(Material material, String variant) {
        for (String k : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            if (!this.plugin.getCustomModelConfig().getString("models." + k + ".item", "CUSTOM").equals(material.toString())) continue;
            return new NamespacedKey((Plugin)this.plugin, TARDISStringUtils.toUnderscoredLowercase(k) + variant);
        }
        return null;
    }
}

