/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.formula;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.formula.FormulaViewer;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.product.Product;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FormulaCommand {
    private final TARDIS plugin;

    public FormulaCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean show(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessenger().message((CommandSender)player, "You need to specify the compound or product you want the formula for! Try using tab complete...");
            return false;
        }
        FormulaViewer holder = new FormulaViewer(this.plugin, player);
        try {
            Compound compound = Compound.valueOf(args[1]);
            holder.getCompoundFormula(compound);
            player.openInventory(holder.getInventory());
            return true;
        }
        catch (IllegalArgumentException ce) {
            try {
                Product product = Product.valueOf(args[1]);
                holder.getProductFormula(product);
                player.openInventory(holder.getInventory());
                return true;
            }
            catch (IllegalArgumentException pe) {
                try {
                    Lab lab = Lab.valueOf(args[1]);
                    holder.getLabFormula(lab);
                    player.openInventory(holder.getInventory());
                    return true;
                }
                catch (IllegalArgumentException le) {
                    this.plugin.getMessenger().message((CommandSender)player, "Could not find a formula for '" + args[1] + "' make sure you typed it correctly.");
                    return true;
                }
            }
        }
    }
}

