/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.formula;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIChemistry;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.compound.CompoundBuilder;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.element.ElementBuilder;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.lab.LabBuilder;
import me.eccentric_nz.tardischemistry.product.Product;
import me.eccentric_nz.tardischemistry.product.ProductBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FormulaViewer
implements InventoryHolder {
    private final TARDIS plugin;
    private final Player player;
    private final ItemStack[] stack = new ItemStack[27];
    private final Inventory inventory;
    private String formula;

    public FormulaViewer(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)(this.formula.replace("_", " ") + " Formula"), (TextColor)NamedTextColor.DARK_RED));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void getCompoundFormula(Compound compound) {
        ItemStack result;
        String[] shape = compound.getFormula().split("-");
        for (int i = 0; i < shape.length; ++i) {
            ItemStack is = null;
            String[] data = shape[i].split(":");
            try {
                Element element = Element.valueOf(data[0]);
                is = ElementBuilder.getElement(element);
                is.setAmount(Integer.parseInt(data[1]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.stack[i + 18] = is;
        }
        this.stack[0] = result = CompoundBuilder.getCompound(compound);
        this.formula = compound.getSymbol();
        this.showView();
    }

    public void getProductFormula(Product product) {
        ItemStack result;
        String[] shape = product.getRecipe().split("\\|");
        String[][] data = new String[3][3];
        data[0] = shape[0].split(",");
        data[1] = shape[1].split(",");
        data[2] = shape[2].split(",");
        int row = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (data[i][j] == null || data[i][j].equals("-")) continue;
                ItemStack is = null;
                try {
                    Material material = Material.valueOf((String)data[i][j]);
                    is = ItemStack.of((Material)material, (int)1);
                }
                catch (IllegalArgumentException me) {
                    try {
                        Compound compound = Compound.valueOf(data[i][j].replace(" ", "_"));
                        is = CompoundBuilder.getCompound(compound);
                    }
                    catch (IllegalArgumentException ce) {
                        try {
                            Element element = Element.valueOf(data[i][j]);
                            is = ElementBuilder.getElement(element);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                int slot = i + j + row;
                this.stack[slot] = is;
            }
            row += 8;
        }
        this.stack[14] = result = ProductBuilder.getProduct(product);
        this.formula = product.toString();
        this.showView();
    }

    public void getLabFormula(Lab lab) {
        ItemStack result;
        String[] shape = lab.getRecipe().split(",");
        for (int i = 0; i < shape.length; ++i) {
            ItemStack is = null;
            if (shape[i].equals("CHARCOAL")) {
                shape[i] = "Charcoal";
            }
            try {
                Compound compound = Compound.valueOf(shape[i].replace(" ", "_"));
                is = CompoundBuilder.getCompound(compound);
            }
            catch (IllegalArgumentException ce) {
                try {
                    Element element = Element.valueOf(shape[i]);
                    is = ElementBuilder.getElement(element);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.stack[i + 18] = is;
        }
        this.stack[0] = result = LabBuilder.getLabProduct(lab);
        this.formula = lab.toString();
        this.showView();
    }

    private void showView() {
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close_im.setItemModel(GUIChemistry.CLOSE.key());
        close.setItemMeta(close_im);
        this.stack[26] = close;
        this.inventory.setContents(this.stack);
    }
}

