/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.product;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischemistry.product.GlowStickMaterial;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GlowStickRunnable
implements Runnable {
    private final TARDIS plugin;
    private final NamespacedKey namespacedKey;

    public GlowStickRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.namespacedKey = new NamespacedKey((Plugin)this.plugin, "glow_stick_time");
    }

    @Override
    public void run() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            ItemStack offHand;
            PlayerInventory inventory = player.getInventory();
            ItemStack mainHand = inventory.getItemInMainHand();
            if (this.isGlowStick(mainHand)) {
                this.damage(mainHand, player, inventory, true);
            }
            if (!this.isGlowStick(offHand = inventory.getItemInOffHand())) continue;
            this.damage(offHand, player, inventory, false);
        }
    }

    private void damage(ItemStack glowStick, Player player, PlayerInventory inventory, boolean main) {
        ItemMeta im = glowStick.getItemMeta();
        PersistentDataContainer pdk = im.getPersistentDataContainer();
        if (pdk.has(this.namespacedKey, PersistentDataType.INTEGER)) {
            int damage = (Integer)pdk.get(this.namespacedKey, PersistentDataType.INTEGER) - 5;
            if (damage <= 0) {
                if (main) {
                    inventory.setItemInMainHand(null);
                } else {
                    inventory.setItemInOffHand(null);
                }
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            } else {
                pdk.set(this.namespacedKey, PersistentDataType.INTEGER, (Object)damage);
                glowStick.setItemMeta(im);
            }
            player.updateInventory();
        }
    }

    private boolean isGlowStick(ItemStack glowStick) {
        if (glowStick == null) {
            return false;
        }
        if (!glowStick.hasItemMeta()) {
            return false;
        }
        ItemMeta im = glowStick.getItemMeta();
        return GlowStickMaterial.isCorrectMaterial(glowStick.getType()) && im.hasItemModel() && (im.hasEnchantmentGlintOverride() || glowStick.containsEnchantment(Enchantment.LOYALTY));
    }
}

