/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.biomeproviders;

import java.util.List;
import java.util.Random;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class TelosBiomeProvider
extends BiomeProvider {
    public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
        SimplexOctaveGenerator generator = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()), 6);
        generator.setScale(0.01);
        double noise = generator.noise((double)x, (double)z, 1.0, 1.0, true);
        if (noise < -0.818) {
            return Biome.DEEP_FROZEN_OCEAN;
        }
        if (noise < -0.636) {
            return Biome.FROZEN_OCEAN;
        }
        if (noise < -0.455) {
            return Biome.FROZEN_RIVER;
        }
        if (noise < -0.273) {
            return Biome.SNOWY_BEACH;
        }
        if (noise < -0.091) {
            return Biome.SNOWY_TAIGA;
        }
        if (noise >= 0.818) {
            return Biome.JAGGED_PEAKS;
        }
        if (noise >= 0.636) {
            return Biome.FROZEN_PEAKS;
        }
        if (noise >= 0.455) {
            return Biome.SNOWY_SLOPES;
        }
        if (noise >= 0.273) {
            return Biome.GROVE;
        }
        if (noise >= 0.091) {
            return Biome.ICE_SPIKES;
        }
        return Biome.SNOWY_PLAINS;
    }

    public List<Biome> getBiomes(WorldInfo worldInfo) {
        return List.of(Biome.SNOWY_BEACH, Biome.SNOWY_PLAINS, Biome.SNOWY_SLOPES, Biome.SNOWY_TAIGA, Biome.FROZEN_OCEAN, Biome.FROZEN_PEAKS, Biome.FROZEN_RIVER, Biome.DEEP_FROZEN_OCEAN, Biome.GROVE, Biome.JAGGED_PEAKS, Biome.ICE_SPIKES);
    }
}

