/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.mojang.datafixers.util.Pair;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.IslandSpiral;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.WaterCircle;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;

public class IslandBlockPopulator
extends BlockPopulator {
    private final WeightedChoice<Material> stones = new WeightedChoice<Material>().add(60.0, Material.STONE).add(10.0, Material.ANDESITE).add(10.0, Material.DIORITE).add(10.0, Material.GRANITE).add(10.0, Material.COAL_ORE);
    private final WeightedChoice<Material> dirts = new WeightedChoice<Material>().add(70.0, Material.DIRT).add(10.0, Material.GRAVEL).add(20.0, Material.COARSE_DIRT);
    private final WeightedChoice<Material> flora = new WeightedChoice<Material>().add(70.0, Material.SHORT_GRASS).add(10.0, Material.RED_TULIP).add(10.0, Material.OXEYE_DAISY).add(10.0, Material.CORNFLOWER);

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        if (x == 0 && z == 0 || random.nextInt(1000) < 1) {
            IslandSpiral spiral = new IslandSpiral();
            double[][] island = spiral.createMatrix(16, 16, random, 0.01);
            boolean[][] blob = WaterCircle.makeBlob();
            int starty = 95;
            int startx = x * 16;
            int startz = z * 16;
            Pair<Integer, Integer> treePos = spiral.getTreePosition();
            int treeX = (Integer)treePos.getFirst();
            int treeZ = (Integer)treePos.getSecond();
            int treeY = 95;
            for (int r = 1; r < 15; ++r) {
                for (int c = 1; c < 15; ++c) {
                    int top;
                    if (!blob[r][c]) continue;
                    double n = island[r][c];
                    int n2 = top = n > 0.0 ? (int)(n * 6.0) : 0;
                    if (r == treeX && c == treeZ) {
                        treeY = starty + top + 1;
                    }
                    int bottom = -6 - (int)(n * 40.0);
                    for (int h = top; h >= bottom; --h) {
                        Material material;
                        int wx = startx + r;
                        int wy = starty + h;
                        int wz = startz + c;
                        if (!limitedRegion.isInRegion(wx, wy, wz)) continue;
                        if (h == top) {
                            material = Material.GRASS_BLOCK;
                            if (random.nextInt(10) < 3) {
                                limitedRegion.setType(wx, wy + 1, wz, this.flora.next());
                            }
                        } else {
                            material = h > top - 3 ? this.dirts.next() : this.stones.next();
                        }
                        limitedRegion.setType(wx, wy, wz, material);
                        System.out.print(".");
                    }
                }
            }
            if (limitedRegion.isInRegion(startx + treeX, treeY, startx + treeZ)) {
                Location location = new Location(null, (double)(startx + treeX), (double)treeY, (double)(startx + treeZ));
                limitedRegion.setType(location.clone().add(0.0, -1.0, 0.0), Material.DIRT);
                if (!limitedRegion.generateTree(location, random, TreeType.TREE)) {
                    limitedRegion.setType(startx + treeX, treeY, startx + treeZ, Material.OAK_SAPLING);
                }
            }
        }
    }

    public static class WeightedChoice<E> {
        private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
        private double total = 0.0;

        public WeightedChoice<E> add(double weight, E result) {
            if (weight <= 0.0) {
                return this;
            }
            this.total += weight;
            this.map.put(this.total, result);
            return this;
        }

        public E next() {
            double value = ThreadLocalRandom.current().nextDouble() * this.total;
            return this.map.higherEntry(value).getValue();
        }
    }
}

