/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class TARDISRegenerationUpdater {
    private final TARDIS plugin;
    private final FileConfiguration regen_config;
    private final HashMap<String, Integer> integerOptions = new HashMap();

    public TARDISRegenerationUpdater(TARDIS plugin) {
        this.plugin = plugin;
        this.regen_config = plugin.getRegenerationConfig();
        this.integerOptions.put("regenerations", 15);
    }

    public void checkConfig() {
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.integerOptions.entrySet()) {
            if (this.regen_config.contains(entry.getKey())) continue;
            this.regen_config.set(entry.getKey(), (Object)entry.getValue());
            ++i;
        }
        if (this.regen_config.contains("regens")) {
            this.regen_config.set("regenerations", (Object)this.regen_config.getInt("regens"));
            this.regen_config.set("regens", null);
            this.regen_config.setComments("regenerations", List.of("the number of times a player can regenerate"));
            ++i;
        }
        try {
            if (i > 0) {
                this.regen_config.save(new File(this.plugin.getDataFolder(), "regeneration.yml"));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new items to regeneration.yml");
            }
        }
        catch (IOException io) {
            this.plugin.debug("Could not save regeneration.yml, " + io.getMessage());
        }
    }
}

