/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class VortexManipulatorConfig {
    final HashMap<String, String> strOptions = new HashMap();
    final HashMap<String, Integer> intOptions = new HashMap();
    final HashMap<String, Boolean> boolOptions = new HashMap();
    private final TARDIS plugin;
    private final FileConfiguration config;

    public VortexManipulatorConfig(TARDIS plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "vortex_manipulator.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        this.boolOptions.put("allow.beacon", true);
        this.boolOptions.put("allow.lifesigns", true);
        this.boolOptions.put("allow.look_at_block", true);
        this.boolOptions.put("allow.messaging", true);
        this.boolOptions.put("allow.multiple", true);
        this.boolOptions.put("allow.teleport", true);
        this.intOptions.put("lifesign_scan_distance", 16);
        this.intOptions.put("max_look_at_distance", 50);
        this.intOptions.put("recipe.amount", 1);
        this.intOptions.put("tachyon_use.beacon", 1000);
        this.intOptions.put("tachyon_use.lifesigns", 15);
        this.intOptions.put("tachyon_use.max", 1000);
        this.intOptions.put("tachyon_use.message", 5);
        this.intOptions.put("tachyon_use.recharge", 25);
        this.intOptions.put("tachyon_use.recharge_interval", 600);
        this.intOptions.put("tachyon_use.travel.coords", 200);
        this.intOptions.put("tachyon_use.travel.random", 100);
        this.intOptions.put("tachyon_use.travel.saved", 50);
        this.intOptions.put("tachyon_use.travel.to_block", 75);
        this.intOptions.put("tachyon_use.travel.world", 150);
        this.intOptions.put("block_travel_malfunction_chance", 0);
        this.strOptions.put("date_format", "dd/MM/YY HH:mm");
        this.strOptions.put("recipe.ingredients.B", "STONE_BUTTON");
        this.strOptions.put("recipe.ingredients.C", "COMPASS");
        this.strOptions.put("recipe.ingredients.G", "GLASS");
        this.strOptions.put("recipe.ingredients.I", "IRON_INGOT");
        this.strOptions.put("recipe.ingredients.O", "GOLD_INGOT");
        this.strOptions.put("recipe.ingredients.W", "CLOCK");
        this.strOptions.put("recipe.lore", "Cheap and nasty time travel");
        this.strOptions.put("recipe.result", "CLOCK");
        this.strOptions.put("recipe.shape", "BBG,WOC,III");
    }

    public void checkConfig() {
        int i = 0;
        for (Map.Entry<String, Boolean> entry : this.boolOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getVortexConfig().set(entry.getKey(), (Object)entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.intOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getVortexConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.strOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getVortexConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        if (i > 0) {
            try {
                String handlesPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "vortex_manipulator.yml";
                this.plugin.getVortexConfig().save(new File(handlesPath));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.VORTEX_MANIPULATOR, "Added " + i + " new items to config");
            }
            catch (IOException io) {
                this.plugin.debug("Could not save vortex_manipulator.yml, " + io.getMessage());
            }
        }
    }
}

