/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.gui;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetMessageById;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMMessageGUI;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TVMMessageGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    int selectedSlot = -1;

    public TVMMessageGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onMessageGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TVMMessageGUI)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 45: {
                break;
            }
            case 46: {
                this.close(player);
                break;
            }
            case 48: {
                this.doPrev(view, player);
                break;
            }
            case 49: {
                this.doNext(view, player);
                break;
            }
            case 51: {
                this.doRead(view, player);
                break;
            }
            case 53: {
                this.doDelete(view, player);
                break;
            }
            default: {
                this.selectedSlot = slot;
            }
        }
    }

    private void doPrev(InventoryView view, Player player) {
        int page = this.getPageNumber(view);
        if (page > 1) {
            int start = page * 44 - 44;
            this.close(player);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMMessageGUI(this.plugin, start, start + 44, player.getUniqueId().toString()).getInventory()), 2L);
        }
    }

    private void doNext(InventoryView view, Player player) {
        int page = this.getPageNumber(view);
        int start = page * 44 + 44;
        this.close(player);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVMMessageGUI(this.plugin, start, start + 44, player.getUniqueId().toString()).getInventory()), 2L);
    }

    private void doRead(InventoryView view, Player player) {
        if (this.selectedSlot != -1) {
            ItemStack is = view.getItem(this.selectedSlot);
            ItemMeta im = is.getItemMeta();
            List lore = im.lore();
            int message_id = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2)));
            TVMResultSetMessageById rsm = new TVMResultSetMessageById(this.plugin, message_id);
            if (rsm.resultSet()) {
                this.close(player);
                TVMUtils.readMessage(player, rsm.getMessage());
                new TVMQueryFactory(this.plugin).setReadStatus(message_id);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SELECT_MSG");
        }
    }

    private void doDelete(InventoryView view, Player player) {
        if (this.selectedSlot != -1) {
            ItemStack is = view.getItem(this.selectedSlot);
            ItemMeta im = is.getItemMeta();
            List lore = im.lore();
            int message_id = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2)));
            TVMResultSetMessageById rsm = new TVMResultSetMessageById(this.plugin, message_id);
            if (rsm.resultSet()) {
                this.close(player);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("message_id", message_id);
                this.plugin.getQueryFactory().doDelete("messages", where);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_DELETED");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SELECT_MSG");
        }
    }
}

