/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.ice_warriors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.monsters.ice_warriors.IceWarriorEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WaterChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class IceWarriorRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;
    private final List<Biome> biomes = new ArrayList<Biome>();

    public IceWarriorRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
        this.biomes.add(Biome.DEEP_FROZEN_OCEAN);
        this.biomes.add(Biome.FROZEN_OCEAN);
        this.biomes.add(Biome.FROZEN_PEAKS);
        this.biomes.add(Biome.FROZEN_RIVER);
        this.biomes.add(Biome.ICE_SPIKES);
        this.biomes.add(Biome.SNOWY_BEACH);
        this.biomes.add(Biome.SNOWY_PLAINS);
        this.biomes.add(Biome.SNOWY_SLOPES);
        this.biomes.add(Biome.SNOWY_TAIGA);
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            long time;
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("ice_warriors.worlds." + name) > 0 && ((time = w.getTime()) > 0L && time < 13187L || time > 22812L)) {
                int warriors = 0;
                Collection piggies = w.getEntitiesByClass(PigZombie.class);
                for (PigZombie pz : piggies) {
                    PersistentDataContainer pdc = pz.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.WARRIOR, PersistentDataType.INTEGER)) continue;
                    ++warriors;
                }
                if (warriors < this.plugin.getMonstersConfig().getInt("ice_warriors.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnIceWarrior((World)w);
                    }
                }
            }
        });
    }

    private void spawnIceWarrior(World world) {
        int z;
        int y;
        Chunk chunk;
        int x;
        Location l;
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0 && this.biomes.contains((l = new Location(world, (double)(x = (chunk = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)]).getX() * 16 + TARDISConstants.RANDOM.nextInt(16)), (double)((y = world.getHighestBlockYAt(x, z = chunk.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16))) + 1), (double)z)).getBlock().getBiome()) && WaterChecker.isNotWater(l)) {
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            LivingEntity warrior = new MonsterSpawner().create(l, Monster.ICE_WARRIOR);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(Monster.ICE_WARRIOR, warrior, false).setHelmetAndInvisibility();
                IceWarriorEquipment.setAnger(warrior);
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)warrior, EntityType.ZOMBIFIED_PIGLIN, Monster.ICE_WARRIOR, l));
            }, 5L);
        }
    }
}

