/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.silurians;

import java.util.ArrayList;
import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SilurianSpawnerListener
implements Listener {
    private final TARDIS plugin;
    private final int spawn_rate;

    public SilurianSpawnerListener(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @EventHandler
    public void onSpawnEvent(SpawnerSpawnEvent event) {
        CreatureSpawner spawner = event.getSpawner();
        if (spawner.getSpawnedType().equals((Object)EntityType.CAVE_SPIDER)) {
            Location cave = event.getLocation();
            String name = WorldProcessor.sanitiseName(cave.getWorld().getName());
            if (this.plugin.getMonstersConfig().getInt("silurians.worlds." + name) <= 0) {
                return;
            }
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(cave)) {
                return;
            }
            ArrayList silurians = new ArrayList();
            Collection skeletons = cave.getWorld().getEntitiesByClass(Skeleton.class);
            skeletons.forEach(s -> {
                PersistentDataContainer pdc = s.getPersistentDataContainer();
                if (pdc.has(TARDISWeepingAngels.SILURIAN, PersistentDataType.INTEGER)) {
                    silurians.add(s);
                }
            });
            if (silurians.size() < this.plugin.getMonstersConfig().getInt("silurians.worlds." + name)) {
                for (int i = 0; i < this.spawn_rate; ++i) {
                    LivingEntity e = new MonsterSpawner().create(cave, Monster.SILURIAN);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        new Equipper(Monster.SILURIAN, e, false).setHelmetAndInvisibility();
                        this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)e, EntityType.SKELETON, Monster.SILURIAN, cave));
                    }, 5L);
                }
            }
        }
    }
}

