/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.FlightModeModel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.FlightMode;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class FlightModeInteraction {
    private final TARDIS plugin;

    public FlightModeInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void process(Player player, int id, Interaction interaction) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
        if (rsp.resultSet()) {
            int mode = rsp.getFlightMode() + 1;
            if (mode > 4) {
                mode = 1;
            }
            FlightMode flightMode = FlightMode.getByMode().get(mode);
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && flightMode == FlightMode.EXTERIOR && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.EXTERIOR_FLIGHT)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Exterior Flight");
                mode = 1;
                flightMode = FlightMode.NORMAL;
            }
            this.plugin.getMessenger().announceRepeater(player, TARDISStringUtils.capitalise(flightMode.toString()));
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("secondary", mode == 4 ? 1 : 0);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            where.put("type", 47);
            this.plugin.getQueryFactory().doUpdate("controls", set, where);
            HashMap<String, Object> setp = new HashMap<String, Object>();
            setp.put("flying_mode", mode);
            HashMap<String, Object> wherep = new HashMap<String, Object>();
            wherep.put("uuid", player.getUniqueId().toString());
            this.plugin.getQueryFactory().doUpdate("player_prefs", setp, wherep);
            UUID model = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
            if (model != null) {
                ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(model);
                new FlightModeModel().setState(display, mode);
            }
        }
    }
}

