/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.InteractionResponse;
import me.eccentric_nz.TARDIS.console.models.WXYZModel;
import me.eccentric_nz.TARDIS.database.InteractionStateSaver;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class WorldInteraction {
    private final TARDIS plugin;

    public WorldInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void selectWorld(int state, Player player, Interaction interaction, int id) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        boolean missing = false;
        int next = state + 1;
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && (next == 3 || next == 4) && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.INTER_DIMENSIONAL_TRAVEL)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Inter Dimensional Travel");
            missing = true;
        }
        if (next > 4 || missing) {
            next = 1;
        }
        if (!missing) {
            UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
            if (uuid != null) {
                ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(uuid);
                new WXYZModel().setState(display, this.plugin, 1);
            }
            new InteractionStateSaver(this.plugin).write("WORLD", next, id);
        }
        this.plugin.getMessenger().announceRepeater(player, InteractionResponse.environment.get(next));
    }
}

