/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ResultSetOccupied {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final List<Integer> data = new ArrayList<Integer>();
    private final String prefix;

    public ResultSetOccupied(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void resultSetAsync(ResultSetOccupiedCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.resultSet();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        long time = System.currentTimeMillis() - 86400000L;
        String query = "SELECT DISTINCT " + this.prefix + "travellers.tardis_id FROM " + this.prefix + "travellers, " + this.prefix + "tardis WHERE " + this.prefix + "tardis.lastuse > " + time + " AND " + this.prefix + "tardis.tardis_id = " + this.prefix + "travellers.tardis_id";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    this.data.add(rs.getInt("tardis_id"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for travellers table [Occupied]! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing travellers table [Occupied]! " + e.getMessage());
            }
        }
    }

    public List<Integer> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public static interface ResultSetOccupiedCallback {
        public void onDone(ResultSetOccupied var1);
    }
}

