/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.outer;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInnerDoorLocations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.portal.Capture;
import me.eccentric_nz.TARDIS.portal.Cast;
import me.eccentric_nz.TARDIS.portal.CastData;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;

public class OuterMinecraftDoorOpener {
    private final TARDIS plugin;

    public OuterMinecraftDoorOpener(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void open(Block block, int id, Player player) {
        if (block != null && Tag.DOORS.isTagged((Keyed)block.getType())) {
            Openable openable = (Openable)block.getBlockData();
            openable.setOpen(true);
            block.setBlockData((BlockData)openable, true);
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            ResultSetInnerDoorLocations resultSetPortal;
            Tardis tardis = rs.getTardis();
            ChameleonPreset preset = tardis.getPreset();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            rsc.resultSet();
            Current current = rsc.getCurrent();
            Location portal = current.location();
            if (preset != null && preset.equals((Object)ChameleonPreset.SWAMP)) {
                portal.add(0.0, 1.0, 0.0);
            }
            if ((resultSetPortal = new ResultSetInnerDoorLocations(this.plugin, id)).resultSet()) {
                Location teleport = resultSetPortal.getTeleportLocation();
                TARDISTeleportLocation tp_in = new TARDISTeleportLocation();
                tp_in.setLocation(teleport);
                tp_in.setTardisId(id);
                tp_in.setDirection(resultSetPortal.getDirection());
                tp_in.setAbandoned(tardis.isAbandoned());
                this.plugin.getTrackerKeeper().getPortals().put(portal, tp_in);
                if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                    this.plugin.getTrackerKeeper().getMovers().add(tardis.getUuid());
                    if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                            this.plugin.getTrackerKeeper().getMovers().add(p.getUniqueId());
                        }
                    } else {
                        Player companions;
                        for (Player c : companions = tardis.getCompanions().split(":")) {
                            if (c.isEmpty()) continue;
                            this.plugin.getTrackerKeeper().getMovers().add(UUID.fromString((String)c));
                        }
                    }
                }
                if (preset != null && preset.equals((Object)ChameleonPreset.INVISIBLE) && this.plugin.getConfig().getBoolean("allow.3d_doors")) {
                    this.plugin.getTrackerKeeper().getInvisibleDoors().put(tardis.getUuid(), block);
                }
                if (this.plugin.getConfig().getBoolean("police_box.view_interior") && preset != null && !preset.usesArmourStand()) {
                    double distance;
                    UUID uuid = player.getUniqueId();
                    ConsoleSize consoleSize = tardis.getSchematic().getConsoleSize();
                    this.plugin.getTrackerKeeper().getCasters().put(uuid, new CastData(resultSetPortal.getDoorLocation(), portal, current.direction(), tardis.getRotor(), consoleSize));
                    Location location = player.getLocation();
                    double d = distance = location.getWorld() == portal.getWorld() ? location.distanceSquared(portal) : 1.0;
                    if (distance <= 9.0) {
                        Capture capture = new Capture();
                        BlockData[][][] data = capture.captureInterior(resultSetPortal.getDoorLocation(), (int)distance, tardis.getRotor(), consoleSize);
                        Cast cast = new Cast(this.plugin, portal);
                        cast.castInterior(uuid, data);
                        if (capture.getRotorData().frame() != null) {
                            cast.castRotor(capture.getRotorData().frame(), player, capture.getRotorData().offset(), current.direction());
                        }
                    }
                }
            }
        }
    }
}

