/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.VariableLight;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.block.Block;
import org.bukkit.block.data.Levelled;
import org.bukkit.plugin.Plugin;

public class TARDISLightSequence {
    private final TARDIS plugin;
    private final int id;
    private final UUID uuid;

    public TARDISLightSequence(TARDIS plugin, int id, UUID uuid) {
        this.plugin = plugin;
        this.id = id;
        this.uuid = uuid;
    }

    public void play() {
        ResultSetLightLevel lightLevel = new ResultSetLightLevel(this.plugin);
        if (lightLevel.fromTypeAndID(50, this.id)) {
            this.plugin.getTrackerKeeper().getLightChangers().add(this.uuid);
            int currentLevel = LightLevel.interior_level[lightLevel.getLevel()];
            ResultSetLightPrefs rs = new ResultSetLightPrefs(this.plugin);
            if (rs.fromID(this.id)) {
                TardisLight currentLight = rs.getLight();
                HashMap<String, Object> whereLight = new HashMap<String, Object>();
                whereLight.put("tardis_id", this.id);
                ResultSetLamps rsl = new ResultSetLamps(this.plugin, whereLight, true);
                if (rsl.resultSet()) {
                    String[] seq = rs.getSequence().split(":");
                    int[] del = this.makeIntArray(rs.getDelays().split(":"));
                    int[] lev = this.makeIntArray(rs.getLevels().split(":"));
                    long delay = 5L;
                    for (int i = 0; i < seq.length; ++i) {
                        if (seq[i].equals("BLACK")) continue;
                        int level = lev[i];
                        TardisLight tardisLight = this.getLight(seq[i]);
                        int remove = i;
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            for (Block block : rsl.getData()) {
                                if (!(block.getBlockData() instanceof Levelled)) continue;
                                if (remove == 0) {
                                    TARDISDisplayItemUtils.remove(block);
                                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new VariableLight(rs.getMaterial(), block.getLocation().add(0.5, 0.5, 0.5)).set(tardisLight.getOn().getCustomModel(), level), 3L);
                                    continue;
                                }
                                new VariableLight(block.getLocation().add(0.5, 0.5, 0.5)).change(tardisLight.getOn().getCustomModel(), level);
                            }
                        }, delay);
                        delay += (long)del[i];
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        for (Block block : rsl.getData()) {
                            TARDISDisplayItemUtils.remove(block);
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                if (currentLight.getOn().isVariable()) {
                                    new VariableLight(rs.getMaterial(), block.getLocation().add(0.5, 0.5, 0.5)).set(currentLight.getOn().getCustomModel(), currentLevel);
                                } else {
                                    TARDISDisplayItemUtils.set(currentLight.getOn(), block, -1);
                                }
                            }, 3L);
                        }
                        this.plugin.getTrackerKeeper().getLightChangers().remove(this.uuid);
                    }, delay);
                }
            }
        }
    }

    private TardisLight getLight(String s) {
        String variable = "VARIABLE_" + s;
        try {
            return TardisLight.valueOf(variable);
        }
        catch (IllegalArgumentException e) {
            return TardisLight.VARIABLE;
        }
    }

    private int[] makeIntArray(String[] strings) {
        int[] longs = new int[strings.length];
        for (int d = 0; d < strings.length; ++d) {
            longs[d] = TARDISNumberParsers.parseInt(strings[d]);
        }
        return longs;
    }
}

