/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.GUIKeyPreferences;
import me.eccentric_nz.TARDIS.custommodels.keys.ChemistryEquipment;
import me.eccentric_nz.TARDIS.custommodels.keys.CircuitVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DiskVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DroidVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.JudoonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MonkVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.OodVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.RegenerationVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SilentVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Whoniverse;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SonicScrewdriver;
import me.eccentric_nz.TARDIS.rooms.debug.DebugGUI;
import me.eccentric_nz.TARDIS.rooms.debug.DebugHandles;
import me.eccentric_nz.TARDIS.rooms.debug.DebugLazarus;
import me.eccentric_nz.TARDIS.rooms.debug.GuiPreview;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.compound.CompoundBuilder;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.element.ElementBuilder;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.lab.LabBuilder;
import me.eccentric_nz.tardischemistry.microscope.LabEquipment;
import me.eccentric_nz.tardischemistry.product.Product;
import me.eccentric_nz.tardischemistry.product.ProductBuilder;
import me.eccentric_nz.tardisregeneration.ElixirOfLife;
import me.eccentric_nz.tardisshop.ShopItem;
import me.eccentric_nz.tardisshop.ShopItemRecipe;
import me.eccentric_nz.tardisweepingangels.equip.ArmourStandEquipment;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;

public class DebugPopulator {
    private final TARDIS plugin;
    private final World world;
    private final int rx = -1552;
    private final int rz = -9744;
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();

    public DebugPopulator(TARDIS plugin, World world) {
        this.plugin = plugin;
        this.world = world;
    }

    public void createBase(boolean clear) {
        TARDISTIPSData tipsData = new TARDISInteriorPostioning(this.plugin).getTIPSData(-50);
        int x = tipsData.getCentreX();
        int z = tipsData.getCentreZ();
        this.plugin.debug("Debug Preview spawn => x" + x + ", y65, z" + z);
        if (clear) {
            Location location = new Location(this.world, (double)x, 65.0, (double)z);
            for (Entity entity : this.world.getNearbyEntities(location, 100.0, 10.0, 100.0)) {
                if (entity instanceof Player) continue;
                entity.remove();
            }
        } else {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", -50);
            set.put("name", "debug_preview");
            set.put("world", this.world.getName());
            set.put("x", (double)x + 0.5);
            set.put("y", 65);
            set.put("z", (double)z + 0.5);
            this.plugin.getQueryFactory().doInsert("transmats", set);
        }
        for (int r = -100; r < 100; ++r) {
            for (int c = -100; c < 100; ++c) {
                this.world.getBlockAt(x + r, 64, z + c).setType(Material.BLACK_CONCRETE);
                this.world.getBlockAt(x + r, 65, z + c).setType(Material.AIR);
                if (r % 2 != 0 || c % 2 != 0) continue;
                this.world.getBlockAt(x + r, 70, z + c).setBlockData((BlockData)TARDISConstants.LIGHT_DIV);
            }
        }
    }

    public void items() {
        int x = -2;
        int z = 2;
        for (ShopItem shopItem : ShopItem.values()) {
            if (shopItem.getRecipeType() != ShopItemRecipe.SHAPED && shopItem.getRecipeType() != ShopItemRecipe.SHAPELESS) continue;
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, shopItem.getMaterial(), shopItem.getModel(), (Component)Component.text((String)shopItem.getDisplayName()));
            if ((x -= 2) >= -24) continue;
            x = -2;
            z += 2;
        }
        NamespacedKey[] data = new NamespacedKey[]{CircuitVariant.TELEPATHIC_DAMAGED.getKey(), CircuitVariant.STATTENHEIM_DAMAGED.getKey(), CircuitVariant.MATERIALISATION_DAMAGED.getKey(), CircuitVariant.LOCATOR_DAMAGED.getKey(), CircuitVariant.CHAMELEON_DAMAGED.getKey(), CircuitVariant.SONIC_DAMAGED.getKey(), CircuitVariant.ARS.getKey(), CircuitVariant.TEMPORAL_DAMAGED.getKey(), CircuitVariant.MEMORY_DAMAGED.getKey(), CircuitVariant.INPUT.getKey(), CircuitVariant.SCANNER_DAMAGED.getKey(), CircuitVariant.PERCEPTION_DAMAGED.getKey(), CircuitVariant.RANDOM_DAMAGED.getKey(), CircuitVariant.INVISIBILITY_DAMAGED.getKey(), CircuitVariant.RIFT_DAMAGED.getKey()};
        String[] names = new String[]{"Telepathic", "Stattenheim", "Materialisation", "Locator", "Chameleon", "Sonic", "ARS", "Temporal", "Memory", "Input", "Scanner", "Perception", "Random", "Invisibility", "Rift"};
        int c = 0;
        for (String damaged : names) {
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, Material.GLOWSTONE_DUST, data[c], (Component)Component.text((String)("Damaged " + damaged + " Circuit")));
            ++c;
            if ((x -= 2) >= -24) continue;
            x = -2;
            z += 2;
        }
        Material[] materialArray = new Material[]{Material.WATER_BUCKET, Material.LAVA_BUCKET, Material.MUSIC_DISC_BLOCKS};
        NamespacedKey[] cmd = new NamespacedKey[]{Whoniverse.ACID_BUCKET.getKey(), Whoniverse.RUST_BUCKET.getKey(), DiskVariant.AREA_DISK.getKey()};
        String[] misc = new String[]{"Acid Bucket", "Rust Bucket", "Area Storage Disk"};
        int b = 0;
        for (String m : misc) {
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, materialArray[b], cmd[b], (Component)Component.text((String)m));
            ++b;
            if ((x -= 2) >= -24) continue;
            x = -2;
            z += 2;
        }
    }

    public void blocks() {
        int x = 2;
        int z = 2;
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            if (tdi == TARDISDisplayItem.NONE || tdi == TARDISDisplayItem.PANDORICA || tdi == TARDISDisplayItem.UNTEMPERED_SCHISM || tdi.getCustomModel() == null || tdi.toString().contains("DOOR")) continue;
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.stacks.add(TARDISDisplayItemUtils.setAndReturnStack(tdi, this.world, -1552 + x, 65, -9744 + z));
            this.addLabel(location, (Component)Component.text((String)tdi.getDisplayName()));
            if ((x += 2) <= 24) continue;
            x = 2;
            z += 2;
        }
    }

    public void sonicAndKeys() {
        int x = 28;
        int z = -3;
        for (SonicScrewdriver sonicScrewdriver : SonicScrewdriver.values()) {
            for (int i = 0; i < 2; ++i) {
                Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
                this.setItemFromMaterial(location, i == 0 ? sonicScrewdriver.getModel() : sonicScrewdriver.getActive(), (Component)Component.text((String)sonicScrewdriver.getName()));
                if ((x += 2) <= 48) continue;
                x = 28;
                z -= 2;
            }
        }
        for (Enum enum_ : GUIKeyPreferences.values()) {
            if (((GUIKeyPreferences)enum_).getSlot() >= 17) continue;
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, ((GUIKeyPreferences)enum_).getMaterial(), ((GUIKeyPreferences)enum_).getModel(), (Component)Component.text((String)((GUIKeyPreferences)enum_).getName()));
            if ((x += 2) <= 48) continue;
            x = 28;
            z -= 2;
        }
    }

    public void monsters() {
        if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            return;
        }
        int x = 3;
        int z = -3;
        for (Monster monster : Monster.values()) {
            ArmorStand as;
            Location loc;
            if (monster != Monster.DALEK) {
                Location location = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                ArmorStand stand = (ArmorStand)this.world.spawnEntity(location, EntityType.ARMOR_STAND);
                new ArmourStandEquipment().setStandEquipment(stand, monster, monster == Monster.EMPTY_CHILD);
                if ((x += 3) > 24) {
                    x = 3;
                    z -= 3;
                }
            }
            if (monster == Monster.CYBERMAN) {
                for (int c = 0; c < 9; ++c) {
                    loc = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                    as = (ArmorStand)this.world.spawnEntity(loc, EntityType.ARMOR_STAND);
                    new ArmourStandEquipment().setStandEquipment(as, monster, false);
                    switch (c) {
                        case 0: {
                            this.setHelmet(as, CybermanVariant.CYBERMAN_RISE_STATIC.getKey());
                            break;
                        }
                        case 1: {
                            this.setHelmet(as, CybermanVariant.CYBER_LORD_STATIC.getKey());
                            break;
                        }
                        case 2: {
                            this.setHelmet(as, CybermanVariant.BLACK_CYBERMAN_STATIC.getKey());
                            break;
                        }
                        case 3: {
                            this.setHelmet(as, CybermanVariant.CYBERMAN_EARTHSHOCK_STATIC.getKey());
                            break;
                        }
                        case 4: {
                            this.setHelmet(as, CybermanVariant.CYBERMAN_INVASION_STATIC.getKey());
                            break;
                        }
                        case 5: {
                            this.setHelmet(as, CybermanVariant.CYBERMAN_MOONBASE_STATIC.getKey());
                            break;
                        }
                        case 6: {
                            this.setHelmet(as, CybermanVariant.CYBERMAN_TENTH_PLANET_STATIC.getKey());
                            break;
                        }
                        case 7: {
                            this.setHelmet(as, CybermanVariant.WOOD_CYBERMAN_STATIC.getKey());
                        }
                    }
                    if ((x += 3) <= 24) continue;
                    x = 3;
                    z -= 3;
                }
            }
            if (monster == Monster.MIRE || monster == Monster.JUDOON || monster == Monster.SLITHEEN || monster == Monster.HEADLESS_MONK || monster == Monster.CLOCKWORK_DROID || monster == Monster.SILENT) {
                Location loc2 = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                ArmorStand as2 = (ArmorStand)this.world.spawnEntity(loc2, EntityType.ARMOR_STAND);
                new ArmourStandEquipment().setStandEquipment(as2, monster, false);
                switch (monster) {
                    case CLOCKWORK_DROID: {
                        this.setHelmet(as2, DroidVariant.CLOCKWORK_DROID_FEMALE_STATIC.getKey());
                        break;
                    }
                    case HEADLESS_MONK: {
                        this.setHelmet(as2, MonkVariant.HEADLESS_MONK_ALTERNATE.getKey());
                        break;
                    }
                    case JUDOON: {
                        this.setHelmet(as2, JudoonVariant.JUDOON_GUARD.getKey());
                        break;
                    }
                    case MIRE: {
                        this.setHelmet(as2, MireVariant.THE_MIRE_HELMETLESS.getKey());
                        break;
                    }
                    case SILENT: {
                        this.setHelmet(as2, SilentVariant.SILENT_BEAMING.getKey());
                        break;
                    }
                    case SLITHEEN: {
                        this.setHelmet(as2, SlitheenVariant.SLITHEEN_SUIT.getKey());
                    }
                }
                if ((x += 3) > 24) {
                    x = 3;
                    z -= 3;
                }
            }
            if (monster == Monster.DALEK) {
                for (int c = 0; c < 16; ++c) {
                    loc = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                    as = (ArmorStand)this.world.spawnEntity(loc, EntityType.ARMOR_STAND);
                    new ArmourStandEquipment().setStandEquipment(as, monster, false);
                    switch (c) {
                        case 0: {
                            this.setHelmet(as, DalekVariant.DALEK_WHITE.getKey());
                            break;
                        }
                        case 1: {
                            this.setHelmet(as, DalekVariant.DALEK_ORANGE.getKey());
                            break;
                        }
                        case 2: {
                            this.setHelmet(as, DalekVariant.DALEK_MAGENTA.getKey());
                            break;
                        }
                        case 3: {
                            this.setHelmet(as, DalekVariant.DALEK_LIGHT_BLUE.getKey());
                            break;
                        }
                        case 4: {
                            this.setHelmet(as, DalekVariant.DALEK_YELLOW.getKey());
                            break;
                        }
                        case 5: {
                            this.setHelmet(as, DalekVariant.DALEK_LIME.getKey());
                            break;
                        }
                        case 6: {
                            this.setHelmet(as, DalekVariant.DALEK_PINK.getKey());
                            break;
                        }
                        case 7: {
                            this.setHelmet(as, DalekVariant.DALEK_GRAY.getKey());
                            break;
                        }
                        case 8: {
                            this.setHelmet(as, DalekVariant.DALEK_LIGHT_GRAY.getKey());
                            break;
                        }
                        case 9: {
                            this.setHelmet(as, DalekVariant.DALEK_CYAN.getKey());
                            break;
                        }
                        case 10: {
                            this.setHelmet(as, DalekVariant.DALEK_PURPLE.getKey());
                            break;
                        }
                        case 11: {
                            this.setHelmet(as, DalekVariant.DALEK_BLUE.getKey());
                            break;
                        }
                        case 12: {
                            this.setHelmet(as, DalekVariant.DALEK_BROWN.getKey());
                            break;
                        }
                        case 13: {
                            this.setHelmet(as, DalekVariant.DALEK_GREEN.getKey());
                            break;
                        }
                        case 14: {
                            this.setHelmet(as, DalekVariant.DALEK_RED.getKey());
                            break;
                        }
                        case 15: {
                            this.setHelmet(as, DalekVariant.DALEK_BLACK.getKey());
                        }
                    }
                    if ((x += 3) <= 24) continue;
                    x = 3;
                    z -= 3;
                }
            }
            if (monster != Monster.OOD) continue;
            for (int c = 411; c < 436; c += 6) {
                loc = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                as = (ArmorStand)this.world.spawnEntity(loc, EntityType.ARMOR_STAND);
                new ArmourStandEquipment().setStandEquipment(as, monster, false);
                switch (c) {
                    case 411: {
                        this.setHelmet(as, OodVariant.OOD_REDEYE_BLACK_STATIC.getKey());
                        break;
                    }
                    case 417: {
                        this.setHelmet(as, OodVariant.OOD_BLUE_STATIC.getKey());
                        break;
                    }
                    case 423: {
                        this.setHelmet(as, OodVariant.OOD_REDEYE_BLUE_STATIC.getKey());
                        break;
                    }
                    case 429: {
                        this.setHelmet(as, OodVariant.OOD_BROWN_STATIC.getKey());
                        break;
                    }
                    case 435: {
                        this.setHelmet(as, OodVariant.OOD_REDEYE_BROWN_STATIC.getKey());
                    }
                }
                if ((x += 3) <= 24) continue;
                x = 3;
                z -= 3;
            }
        }
    }

    private void setHelmet(ArmorStand as, NamespacedKey key) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            EntityEquipment ee = as.getEquipment();
            ItemStack head = ee.getHelmet();
            ItemMeta meta = head.getItemMeta();
            meta.setItemModel(key);
            head.setItemMeta(meta);
            ee.setHelmet(head);
            this.stacks.add(head);
        }, 2L);
    }

    public void chameleon() {
        int x = -4;
        int r = 0;
        for (ChameleonPreset preset : ChameleonPreset.values()) {
            if (!preset.usesArmourStand() || preset == ChameleonPreset.ITEM) continue;
            for (int z = -4 - r; z > -17 - r; z -= 4) {
                Location loc = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                ArmorStand as = (ArmorStand)this.world.spawnEntity(loc, EntityType.ARMOR_STAND);
                EntityEquipment ee = as.getEquipment();
                Material dye = TARDISBuilderUtility.getMaterialForArmourStand(preset, -1, true);
                ItemStack head = ItemStack.of((Material)dye, (int)1);
                ItemMeta meta = head.getItemMeta();
                switch (z) {
                    case -20: 
                    case -4: {
                        meta.setItemModel(preset.getClosed());
                        break;
                    }
                    case -24: 
                    case -8: {
                        meta.setItemModel(preset.getOpen());
                        break;
                    }
                    case -28: 
                    case -12: {
                        meta.setItemModel(preset.getStained());
                        break;
                    }
                    default: {
                        meta.setItemModel(preset.getGlass());
                    }
                }
                head.setItemMeta(meta);
                ee.setHelmet(head);
                as.setInvisible(true);
                this.stacks.add(head);
            }
            if ((x -= 4) >= -49) continue;
            x = -4;
            r += 16;
        }
        for (String c : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            for (int z = -4 - r; z > -17 - r; z -= 4) {
                Location loc = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
                ArmorStand as = (ArmorStand)this.world.spawnEntity(loc, EntityType.ARMOR_STAND);
                EntityEquipment ee = as.getEquipment();
                Material material = Material.valueOf((String)this.plugin.getCustomModelConfig().getString("models." + c + ".item"));
                ItemStack head = ItemStack.of((Material)material, (int)1);
                ItemMeta meta = head.getItemMeta();
                meta.setItemModel(switch (z) {
                    case -20, -4 -> new NamespacedKey((Plugin)this.plugin, TARDISStringUtils.toUnderscoredLowercase(c) + "_closed");
                    case -24, -8 -> new NamespacedKey((Plugin)this.plugin, TARDISStringUtils.toUnderscoredLowercase(c) + "_open");
                    case -28, -12 -> new NamespacedKey((Plugin)this.plugin, TARDISStringUtils.toUnderscoredLowercase(c) + "_stained");
                    default -> new NamespacedKey((Plugin)this.plugin, TARDISStringUtils.toUnderscoredLowercase(c) + "_glass");
                });
                head.setItemMeta(meta);
                ee.setHelmet(head);
                as.setInvisible(true);
                this.stacks.add(head);
            }
            if ((x -= 4) >= -49) continue;
            x = -4;
            r += 16;
        }
    }

    public void rotors() {
        int x = 28;
        int z = 2;
        for (Rotor rotor : Rotor.byCustomModel.values()) {
            Location location = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
            ItemFrame frame = (ItemFrame)this.world.spawnEntity(location, EntityType.ITEM_FRAME);
            frame.setFacingDirection(BlockFace.UP, true);
            ItemStack is = ItemStack.of((Material)Material.LIGHT_GRAY_DYE);
            ItemMeta im = is.getItemMeta();
            im.setItemModel(rotor.offModel());
            is.setItemMeta(im);
            frame.setItem(is);
            frame.setFixed(true);
            frame.setVisible(false);
            if ((x += 4) > 50) {
                x = 28;
                z += 4;
            }
            this.stacks.add(is);
        }
    }

    public void doors() {
        ItemMeta im;
        ItemStack is;
        Material material;
        int x = -27;
        int z = 2;
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            if (!tdi.toString().contains("DOOR") || tdi == TARDISDisplayItem.CUSTOM_DOOR) continue;
            Location location = new Location(this.world, (double)(-1552 + x) + 0.5, 65.5, (double)(-9744 + z) + 0.5);
            ItemDisplay display = (ItemDisplay)this.world.spawnEntity(location, EntityType.ITEM_DISPLAY);
            material = tdi.toString().contains("OPEN") ? tdi.getMaterial() : tdi.getCraftMaterial();
            is = ItemStack.of((Material)material);
            im = is.getItemMeta();
            im.setItemModel(tdi.getCustomModel());
            is.setItemMeta(im);
            display.setItemStack(is);
            if ((x -= 3) >= -50) continue;
            x = -27;
            z += 3;
        }
        for (String door : this.plugin.getCustomDoorsConfig().getKeys(false)) {
            Door d = Door.byName.get("DOOR_" + door.toUpperCase(Locale.ROOT));
            String key = TARDISStringUtils.toUnderscoredLowercase(door);
            this.plugin.debug(key);
            Location closed = new Location(this.world, (double)(-1552 + x) + 0.5, 65.5, (double)(-9744 + z) + 0.5);
            ItemDisplay c = (ItemDisplay)this.world.spawnEntity(closed, EntityType.ITEM_DISPLAY);
            material = d.getMaterial();
            is = ItemStack.of((Material)material);
            im = is.getItemMeta();
            im.setItemModel(new NamespacedKey((Plugin)this.plugin, key + "_closed"));
            is.setItemMeta(im);
            this.stacks.add(is);
            c.setItemStack(is);
            if ((x -= 3) < -48) {
                x = -27;
                z += 3;
            }
            Location open = new Location(this.world, (double)(-1552 + x) + 0.5, 65.5, (double)(-9744 + z) + 0.5);
            ItemDisplay o = (ItemDisplay)this.world.spawnEntity(open, EntityType.ITEM_DISPLAY);
            ItemStack ois = ItemStack.of((Material)material);
            ItemMeta oim = is.getItemMeta();
            im.setItemModel(new NamespacedKey((Plugin)this.plugin, key + "_open"));
            ois.setItemMeta(oim);
            o.setItemStack(ois);
            this.stacks.add(ois);
            if ((x -= 3) < -48) {
                x = -27;
                z += 3;
            }
            if (!d.hasExtra()) continue;
            Location extra = new Location(this.world, (double)(-1552 + x) + 0.5, 65.5, (double)(-9744 + z) + 0.5);
            ItemDisplay e = (ItemDisplay)this.world.spawnEntity(extra, EntityType.ITEM_DISPLAY);
            ItemStack eis = ItemStack.of((Material)material);
            ItemMeta eim = is.getItemMeta();
            eim.setItemModel(new NamespacedKey((Plugin)this.plugin, key + "_extra"));
            eis.setItemMeta(eim);
            e.setItemStack(eis);
            this.stacks.add(eis);
            if ((x -= 3) >= -48) continue;
            x = -27;
            z += 3;
        }
    }

    public void consoles() {
        int x = -52;
        int z = 4;
        for (String colour : TARDISConstants.COLOURS) {
            Block block = this.world.getBlockAt(-1552 + x, 65, -9744 + z);
            block.setType(Material.WHITE_CONCRETE);
            new ConsoleBuilder(this.plugin).create(block, colour, -1, UUID.randomUUID().toString());
            if ((x -= 6) >= -76) continue;
            x = -52;
            z += 6;
        }
    }

    public void gui() {
        int x = -2;
        int z = 27;
        for (GuiPreview gui : DebugGUI.ICONS) {
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, gui.material(), gui.model(), (Component)Component.text((String)gui.name()));
            if ((x -= 2) >= -48) continue;
            x = -2;
            z += 2;
        }
    }

    private void setItemFromMaterial(Location location, Material material, NamespacedKey model, Component name) {
        location.getBlock().setType(Material.WHITE_CONCRETE);
        ItemStack is = ItemStack.of((Material)material, (int)1);
        ItemMeta im = is.getItemMeta();
        im.setItemModel(model);
        im.displayName(name);
        is.setItemMeta(im);
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
        display.setInvulnerable(true);
        this.addLabel(location, name);
        this.stacks.add(is);
    }

    private void setItemFromMaterial(Location location, List<Float> floats, Component name) {
        location.getBlock().setType(Material.WHITE_CONCRETE);
        ItemStack is = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
        ItemMeta im = is.getItemMeta();
        CustomModelDataComponent cmd = im.getCustomModelDataComponent();
        cmd.setFloats(floats);
        im.setCustomModelDataComponent(cmd);
        im.displayName(name);
        is.setItemMeta(im);
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
        display.setInvulnerable(true);
        this.addLabel(location, name);
        this.stacks.add(is);
    }

    private void setItemFromStack(Location location, ItemStack is, Component name) {
        this.stacks.add(is);
        location.getBlock().setType(Material.WHITE_CONCRETE);
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
        display.setInvulnerable(true);
        this.addLabel(location, name);
    }

    private void addLabel(Location location, Component name) {
        TextDisplay text = (TextDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.65, 0.5), EntityType.TEXT_DISPLAY);
        text.setAlignment(TextDisplay.TextAlignment.CENTER);
        text.text(name);
        text.setTransformation(new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, TARDISConstants.VECTOR_QUARTER, TARDISConstants.AXIS_ANGLE_ZERO));
        text.setBillboard(Display.Billboard.VERTICAL);
    }

    public void chemistry() {
        Location location;
        ItemStack chemical;
        int x = 3;
        int z = 27;
        for (LabEquipment le : LabEquipment.values()) {
            Location location2 = new Location(this.world, (double)(-1552 + x) + 0.5, 65.0, (double)(-9744 + z) + 0.5);
            ItemFrame frame = (ItemFrame)this.world.spawnEntity(location2, EntityType.ITEM_FRAME);
            frame.setFacingDirection(BlockFace.UP, true);
            ItemStack is = ItemStack.of((Material)le.getMaterial());
            ItemMeta itemMeta = is.getItemMeta();
            itemMeta.setItemModel(le.getModel());
            is.setItemMeta(itemMeta);
            frame.setItem(is);
            frame.setFixed(true);
            frame.setVisible(false);
            this.stacks.add(is);
            if ((x += 3) <= 24) continue;
            x = 3;
            z += 3;
        }
        List<Material> slides = List.of(Material.GLASS, Material.GRAY_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS);
        String[] names = new String[]{"Slide", "Scope View", "Screen"};
        NamespacedKey[] keys = new NamespacedKey[]{ChemistryEquipment.GLASS_SLIDE.getKey(), ChemistryEquipment.FOLDER.getKey(), ChemistryEquipment.SCREEN.getKey()};
        int s = 0;
        for (Material material : slides) {
            Location location3 = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location3, material, keys[s], (Component)Component.text((String)names[s]));
            ++s;
            if ((x += 2) <= 24) continue;
            x = 3;
            z += 2;
        }
        for (Compound compound : Compound.values()) {
            chemical = CompoundBuilder.getCompound(compound);
            location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromStack(location, chemical, (Component)Component.text((String)compound.getName()));
            if ((x += 2) <= 24) continue;
            x = 3;
            z += 2;
        }
        for (Enum enum_ : Lab.values()) {
            chemical = LabBuilder.getLabProduct((Lab)enum_);
            location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromStack(location, chemical, (Component)Component.text((String)((Lab)enum_).getName()));
            if ((x += 2) <= 24) continue;
            x = 3;
            z += 2;
        }
        for (Enum enum_ : Product.values()) {
            chemical = ProductBuilder.getProduct((Product)enum_);
            location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromStack(location, chemical, (Component)Component.text((String)((Product)enum_).getName()));
            if ((x += 2) <= 24) continue;
            x = 3;
            z += 2;
        }
        for (Enum enum_ : Element.values()) {
            chemical = ElementBuilder.getElement((Element)enum_);
            location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromStack(location, chemical, (Component)Component.text((String)enum_.toString()));
            if ((x += 2) <= 24) continue;
            x = 3;
            z += 2;
        }
    }

    public void regeneration() {
        int x = 3;
        int z = -30;
        ItemStack elixir = ElixirOfLife.create();
        Location loc = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
        this.setItemFromStack(loc, elixir, (Component)Component.text((String)"Elixir of Life"));
        Block block = this.world.getBlockAt(-1552 + (x += 5), 65, -9744 + z);
        TARDISDisplayItemUtils.set(TARDISDisplayItem.UNTEMPERED_SCHISM, block, -1);
        x += 5;
        for (RegenerationVariant t : RegenerationVariant.values()) {
            Location location = new Location(this.world, (double)(-1552 + x) + 0.5, 65.725, (double)(-9744 + z) + 0.5);
            ItemStack totem = ItemStack.of((Material)Material.TOTEM_OF_UNDYING, (int)1);
            ItemMeta im = totem.getItemMeta();
            im.setItemModel(t.getKey());
            totem.setItemMeta(im);
            ItemDisplay display = (ItemDisplay)this.world.spawnEntity(location, EntityType.ITEM_DISPLAY);
            display.setItemStack(totem);
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
            this.stacks.add(totem);
            if ((x += 4) <= 24) continue;
            x = 3;
            z -= 3;
        }
    }

    public void handles() {
        int x = 27;
        int z = -27;
        for (GuiPreview gui : DebugHandles.ICONS) {
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, gui.material(), gui.model(), (Component)Component.text((String)gui.name()));
            if ((x += 2) <= 48) continue;
            x = 27;
            z -= 2;
        }
    }

    public void lazarus() {
        int x = 27;
        int z = 27;
        for (GuiPreview gui : DebugLazarus.ICONS) {
            Location location = new Location(this.world, (double)(-1552 + x), 65.0, (double)(-9744 + z));
            this.setItemFromMaterial(location, gui.material(), gui.model(), (Component)Component.text((String)gui.name()));
            if ((x += 2) <= 48) continue;
            x = 27;
            z += 2;
        }
    }

    public void setChests() {
        Location location = new Location(this.world, -1500.0, 65.0, -9744.0);
        int chests = this.stacks.size() / 27 + 1;
        for (int i = 0; i < chests; ++i) {
            location.getBlock().getRelative(BlockFace.EAST, i).setType(Material.CHEST);
        }
        int count = 0;
        int chestNum = 0;
        Chest chest = (Chest)location.getBlock().getState();
        for (ItemStack is : this.stacks) {
            if (count == 27) {
                count = 0;
                chest = (Chest)location.getBlock().getRelative(BlockFace.EAST, ++chestNum).getState();
            }
            chest.getBlockInventory().addItem(new ItemStack[]{is});
            ++count;
        }
    }
}

