/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.tardisvortexmanipulator.storage.TVMSave;
import org.bukkit.World;

public class TVMResultSetSaves {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String uuid;
    private final int start;
    private final int limit;
    private final List<TVMSave> saves = new ArrayList<TVMSave>();
    private final String prefix;

    public TVMResultSetSaves(TARDIS plugin, String uuid, int start, int limit) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.start = start;
        this.limit = limit;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = String.format("SELECT * FROM " + this.prefix + "saves WHERE uuid = ? ORDER BY save_name LIMIT %d, %d", this.start, this.start + this.limit);
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        TVMSave tvms = new TVMSave();
                        tvms.setId(rs.getInt("save_id"));
                        tvms.setName(rs.getString("save_name"));
                        String w = rs.getString("world");
                        tvms.setWorld(w);
                        tvms.setX(rs.getFloat("x"));
                        tvms.setY(rs.getFloat("y"));
                        tvms.setZ(rs.getFloat("z"));
                        World world = this.plugin.getServer().getWorld(w);
                        tvms.setEnv(world != null ? world.getEnvironment().toString() : "NORMAL");
                        this.saves.add(tvms);
                    }
                    break block17;
                }
                boolean tvms = false;
                return tvms;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for saves table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing saves table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<TVMSave> getSaves() {
        return this.saves;
    }
}

