/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.headless_monks;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessFlameRunnable;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessShootRunnable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HeadlessTarget
implements Listener {
    private final TARDIS plugin;

    public HeadlessTarget(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onHeadlessMonkTarget(EntityTargetLivingEntityEvent event) {
        Entity attacker = event.getEntity();
        LivingEntity target = event.getTarget();
        if (!(attacker instanceof Skeleton)) {
            return;
        }
        Skeleton skeleton = (Skeleton)attacker;
        if (!(target instanceof Player)) {
            return;
        }
        if (!skeleton.getPersistentDataContainer().has(TARDISWeepingAngels.HEADLESS_TASK, PersistentDataType.INTEGER)) {
            return;
        }
        int taskID = (Integer)skeleton.getPersistentDataContainer().get(TARDISWeepingAngels.HEADLESS_TASK, PersistentDataType.INTEGER);
        int flameID = (Integer)skeleton.getPersistentDataContainer().get(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER);
        EntityTargetEvent.TargetReason reason = event.getReason();
        if (reason == EntityTargetEvent.TargetReason.CLOSEST_PLAYER || reason == EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY) {
            if (taskID == -1) {
                HeadlessShootRunnable shooter = new HeadlessShootRunnable(attacker, (Entity)target, this.plugin.getMonstersConfig().getString("headless_monks.projectile", "SMALL_FIREBALL").equals("SMALL_FIREBALL"));
                taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)shooter, 1L, 40L);
                shooter.setTaskID(taskID);
                skeleton.getPersistentDataContainer().set(TARDISWeepingAngels.HEADLESS_TASK, PersistentDataType.INTEGER, (Object)taskID);
            }
            if (flameID != -1) {
                this.plugin.getServer().getScheduler().cancelTask(flameID);
                skeleton.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)-1);
            }
        } else {
            if (taskID != -1) {
                this.plugin.getServer().getScheduler().cancelTask(taskID);
                skeleton.getPersistentDataContainer().set(TARDISWeepingAngels.HEADLESS_TASK, PersistentDataType.INTEGER, (Object)-1);
            }
            if (this.plugin.getMonstersConfig().getBoolean("headless_monks.particles") && flameID == -1) {
                flameID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HeadlessFlameRunnable((LivingEntity)attacker), 1L, 20L);
                skeleton.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)flameID);
            }
        }
    }
}

