/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.protection.TARDISWorldGuardFlag;
import org.bukkit.command.CommandSender;

class TARDISSetRespectCommand {
    private final TARDIS plugin;
    private final ImmutableList<String> regions = ImmutableList.of((Object)"none", (Object)"wilderness", (Object)"town", (Object)"nation");
    private final ImmutableList<String> flags = ImmutableList.copyOf(TARDISWorldGuardFlag.getFLAG_LOOKUP().keySet());

    TARDISSetRespectCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean setRegion(CommandSender sender, String[] args) {
        String region = args[1].toLowerCase(Locale.ROOT);
        if (!this.regions.contains((Object)region)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_TOWNY");
            return false;
        }
        this.plugin.getConfig().set("preferences.respect_towny", (Object)region);
        this.plugin.saveConfig();
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", "respect_towny");
        return true;
    }

    boolean setFlag(CommandSender sender, String[] args) {
        String flag = args[1].toLowerCase(Locale.ROOT);
        if (!this.flags.contains((Object)flag)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_FLAG");
            return false;
        }
        this.plugin.getConfig().set("preferences.respect_worldguard", (Object)flag);
        this.plugin.saveConfig();
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", "respect_worldguard");
        return true;
    }
}

