/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.remote;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISRemoteRebuildCommand {
    private final TARDIS plugin;

    public TARDISRemoteRebuildCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean doRemoteRebuild(CommandSender sender, int id, OfflinePlayer player, boolean hidden) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return true;
        }
        ResultSetTardisPreset rs = new ResultSetTardisPreset(this.plugin);
        if (rs.fromID(id) && rs.getPreset().equals((Object)ChameleonPreset.INVISIBLE)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_ENGAGED");
            return true;
        }
        Current current = rsc.getCurrent();
        BuildData bd = new BuildData(player.getUniqueId().toString());
        bd.setDirection(current.direction());
        bd.setLocation(current.location());
        bd.setMalfunction(false);
        bd.setOutside(false);
        bd.setPlayer(player);
        bd.setRebuild(true);
        bd.setSubmarine(current.submarine());
        bd.setTardisID(id);
        bd.setThrottle(SpaceTimeThrottle.REBUILD);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 10L);
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_REBUILT");
        if (hidden) {
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            HashMap<String, Object> seth = new HashMap<String, Object>();
            seth.put("hidden", 0);
            this.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
        }
        return true;
    }
}

