/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchive;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchiveCount;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchiveName;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchiveUse;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicBuilder;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISArchiveCommand {
    private final TARDIS plugin;
    private final List<String> subs = List.of("add", "description", "remove", "rename", "scan", "update", "y");

    TARDISArchiveCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean zip(Player player, String[] args) {
        HashMap<String, Object> whereu;
        String name;
        if (!TARDISPermission.hasPermission(player, "tardis.archive")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        String sub = args[1].toLowerCase(Locale.ROOT);
        if (!this.subs.contains(sub)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_NOT_VALID");
            return true;
        }
        String uuid = player.getUniqueId().toString();
        String string = name = args.length > 2 ? args[2].toUpperCase(Locale.ROOT) : "ARCHIVE";
        if (sub.equals("add") || sub.equals("description") || sub.equals("remove") || sub.equals("update") || sub.equals("y")) {
            ResultSetArchiveUse rsu;
            ResultSetArchiveCount rsc;
            if (args.length < 3) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NAME");
                return true;
            }
            ResultSetArchiveName rsa = new ResultSetArchiveName(this.plugin, name);
            boolean exists = rsa.exists();
            if (sub.equals("add") && exists) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_EXIST", name);
                return true;
            }
            if ((sub.equals("description") || sub.equals("remove") || sub.equals("update") || sub.equals("y")) && !exists) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
                return true;
            }
            if (sub.equals("add") && (rsc = new ResultSetArchiveCount(this.plugin, uuid)).count() >= this.plugin.getConfig().getInt("archive.limit")) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "ARCHIVE_LIMIT", "/tardis archive update", this.plugin);
                return true;
            }
            if (sub.equals("remove") && (rsu = new ResultSetArchiveUse(this.plugin, uuid, name)).isActive()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_IN_USE");
                return true;
            }
        }
        if (sub.equals("y")) {
            if (args.length > 3 && (args[3].equals("64") || args[3].equals("65"))) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("y", TARDISNumberParsers.parseInt(args[3]));
                HashMap<String, Object> wherey = new HashMap<String, Object>();
                wherey.put("uuid", uuid);
                wherey.put("name", name);
                this.plugin.getQueryFactory().doUpdate("archive", set, wherey);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_UPDATE", name);
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_Y");
            }
            return true;
        }
        if (sub.equals("scan") || sub.equals("add") || sub.equals("update")) {
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", uuid);
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
            if (rst.resultSet()) {
                int id = rst.getTardis_id();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                where.put("uuid", uuid);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    Schematic current = tardis.getSchematic();
                    JsonObject obj = null;
                    if (current.getPermission().equals("archive")) {
                        HashMap<String, Object> wherean = new HashMap<String, Object>();
                        wherean.put("uuid", uuid);
                        wherean.put("name", name);
                        ResultSetArchive rsa = new ResultSetArchive(this.plugin, wherean);
                        if (rsa.resultSet()) {
                            Archive archive = rsa.getArchive();
                            obj = archive.getJSON();
                        }
                    } else {
                        obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", current.getPermission(), current.isCustom());
                    }
                    if (obj != null) {
                        int sz;
                        int sx;
                        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                        int h = dimensions.get("height").getAsInt() - 1;
                        int w = dimensions.get("width").getAsInt() - 1;
                        int c = dimensions.get("length").getAsInt() - 1;
                        ConsoleSize console_size = ConsoleSize.getByWidthAndHeight(w, h);
                        if ((args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("update")) && args.length == 4 || args[1].equalsIgnoreCase("scan") && args.length == 3) {
                            try {
                                String size = args[1].equalsIgnoreCase("scan") ? args[2] : args[3];
                                console_size = ConsoleSize.valueOf(size.toUpperCase(Locale.ROOT));
                                switch (console_size) {
                                    case MASSIVE: {
                                        h = 31;
                                        w = 47;
                                        c = 47;
                                        break;
                                    }
                                    case WIDE: {
                                        h = 15;
                                        w = 47;
                                        c = 47;
                                        break;
                                    }
                                    case TALL: {
                                        h = 31;
                                        w = 31;
                                        c = 31;
                                        break;
                                    }
                                    case MEDIUM: {
                                        h = 15;
                                        w = 31;
                                        c = 31;
                                        break;
                                    }
                                    default: {
                                        h = 15;
                                        w = 15;
                                        c = 15;
                                        break;
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_SIZE");
                                return true;
                            }
                        }
                        int slot = tardis.getTIPS();
                        id = tardis.getTardisId();
                        if (slot != -1000001) {
                            TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                            TARDISTIPSData pos = tintpos.getTIPSData(slot);
                            sx = pos.getCentreX();
                            sz = pos.getCentreZ();
                        } else {
                            int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                            sx = gsl[0];
                            sz = gsl[2];
                        }
                        int sy = current.getStartY();
                        TARDISSchematicBuilder.ArchiveData ad = new TARDISSchematicBuilder(this.plugin, id, player.getLocation().getWorld(), sx, sx + w, sy, sy + h, sz, sz + c).build();
                        if (sub.equals("scan")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_SCAN");
                            return true;
                        }
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("data", ad.getJSON().toString());
                        set.put("console_size", console_size.toString());
                        set.put("beacon", ad.getBeacon());
                        String lights = "TENTH";
                        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
                        if (rsp.resultSet()) {
                            lights = rsp.getLights().toString();
                        }
                        set.put("lanterns", lights);
                        if (sub.equals("add")) {
                            set.put("uuid", uuid);
                            set.put("name", name);
                            set.put("y", sy);
                            this.plugin.getQueryFactory().doInsert("archive", set);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_ADD", name);
                        } else {
                            HashMap<String, Object> whereu2 = new HashMap<String, Object>();
                            whereu2.put("uuid", uuid);
                            whereu2.put("name", name);
                            this.plugin.getQueryFactory().doUpdate("archive", set, whereu2);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_UPDATE", name);
                        }
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NO_JSON");
                    }
                    return true;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_ONLY_TL");
                return true;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_IN_WORLD");
            return true;
        }
        if (sub.equals("description")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 3; i < args.length; ++i) {
                if (i != 3) {
                    sb.append(" ").append(args[i]);
                    continue;
                }
                sb.append(args[i]);
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("description", sb.toString());
            whereu = new HashMap<String, Object>();
            whereu.put("uuid", uuid);
            whereu.put("name", name);
            this.plugin.getQueryFactory().doUpdate("archive", set, whereu);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_DESC", name);
            return true;
        }
        if (sub.equals("remove")) {
            HashMap<String, Object> whereu3 = new HashMap<String, Object>();
            whereu3.put("uuid", uuid);
            whereu3.put("name", name);
            this.plugin.getQueryFactory().doDelete("archive", whereu3);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_REMOVE", name);
        }
        if (sub.equals("rename")) {
            String rename = args[3];
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("name", rename);
            whereu = new HashMap();
            whereu.put("uuid", uuid);
            whereu.put("name", name);
            this.plugin.getQueryFactory().doUpdate("archive", set, whereu);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_RENAME", rename);
            return true;
        }
        return true;
    }
}

