/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.FlightEnd;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.flight.FlyingInit;
import me.eccentric_nz.TARDIS.flight.TARDISHandbrake;
import me.eccentric_nz.TARDIS.flight.TARDISLoopingFlightSound;
import me.eccentric_nz.TARDIS.flight.vehicle.InterpolatedAnimation;
import me.eccentric_nz.TARDIS.flight.vehicle.TARDISArmourStand;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.sensor.BeaconSensor;
import me.eccentric_nz.TARDIS.sensor.HandbrakeSensor;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class TARDISExteriorFlight {
    private final TARDIS plugin;

    public TARDISExteriorFlight(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void stopFlying(Player player, ArmorStand stand) {
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        UUID uuid = player.getUniqueId();
        this.plugin.getTrackerKeeper().getHiddenFlight().remove(uuid);
        Location location = stand.getLocation();
        boolean drifting = false;
        String direction = player.getFacing().getOppositeFace().toString();
        FlightReturnData data = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(uuid);
        if (data != null) {
            Location interior = data.location();
            if (!this.plugin.getPluginRespect().getRespect(location, new Parameters(player, Flag.getDefaultFlags())) || this.plugin.getTardisArea().isInExistingArea(location)) {
                stand.remove();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TARDISLoopingFlightSound(this.plugin, interior, data.id()), 20L);
                this.plugin.getTrackerKeeper().getInVortex().add(data.id());
                this.plugin.getTrackerKeeper().getDidDematToVortex().add(data.id());
                drifting = true;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "FLIGHT_PROTECTED");
            }
            this.plugin.getServer().getScheduler().cancelTask(data.animation());
            this.plugin.getServer().getScheduler().cancelTask(data.sound());
            ItemDisplay display = (ItemDisplay)player.getPassengers().getFirst();
            ItemStack is = display.getItemStack();
            player.eject();
            display.remove();
            if (!drifting) {
                EntityEquipment ee = stand.getEquipment();
                ee.setHelmet(is);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", location.getWorld().getName());
                set.put("x", location.getBlockX());
                set.put("y", location.getBlockY());
                set.put("z", location.getBlockZ());
                set.put("direction", direction);
                set.put("submarine", player.isInWater() ? 1 : 0);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", data.id());
                this.plugin.getQueryFactory().doUpdate("current", set, where);
                TARDISBuilderUtility.saveDoorLocation(location, data.id(), direction);
                Block under = location.getBlock().getRelative(BlockFace.DOWN);
                if (under.getType().isAir()) {
                    TARDISBlockSetters.setUnderDoorBlock(location.getWorld(), under.getX(), under.getY(), under.getZ(), data.id(), false);
                }
                Levelled light = TARDISConstants.LIGHT;
                light.setLevel(7);
                location.getBlock().getRelative(BlockFace.UP, 2).setBlockData((BlockData)light);
                TARDISDisplayItemUtils.setInteraction(stand, data.id());
            }
            player.teleport(interior);
            HashMap<String, Object> sett = new HashMap<String, Object>();
            sett.put("tardis_id", data.id());
            sett.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doSyncInsert("travellers", sett);
            this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(data.id()));
            this.plugin.getTrackerKeeper().getMalfunction().remove(data.id());
            if (!drifting) {
                this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(data.id()));
                if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(data.id())) {
                    this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(data.id()));
                }
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(data.id())) {
                    int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(data.id());
                    this.plugin.getServer().getScheduler().cancelTask(taskID);
                    this.plugin.getTrackerKeeper().getDestinationVortex().remove(data.id());
                }
                new FlightEnd(this.plugin).process(data.id(), player, false, true);
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> {
            COMPASS compass = COMPASS.valueOf(direction);
            stand.teleport(new Location(location.getWorld(), (double)location.getBlockX() + 0.5, (double)location.getBlockY(), (double)location.getBlockZ() + 0.5, compass.getYaw(), 0.0f));
        });
    }

    public void startFlying(Player player, int id, Block block, Location current, boolean beac_on, String beacon) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.debug("No current location");
            return;
        }
        Location interior = player.getLocation();
        if (block != null) {
            TARDISHandbrake.setLevers(block, false, true, block.getLocation().toString(), id, this.plugin);
            TARDISSounds.playTARDISSound(block.getLocation(), "tardis_handbrake_release");
        }
        if (this.plugin.getConfig().getBoolean("circuits.damage")) {
            this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().remove(id);
        }
        if (!beac_on && !beacon.isEmpty()) {
            new BeaconSensor().toggle(beacon, true);
        }
        new HandbrakeSensor(this.plugin, id).toggle();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("handbrake_on", 0);
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
        this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_OFF");
        this.plugin.getTrackerKeeper().getInVortex().add(id);
        UUID uuid = player.getUniqueId();
        this.plugin.getTrackerKeeper().getStillFlyingNotReturning().add(uuid);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            player.setGravity(false);
            player.teleport(current.clone().add(0.5, 0.25, 0.5));
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (Entity e : current.getWorld().getNearbyEntities(current, 1.5, 1.5, 1.5, s -> s.getType() == EntityType.ARMOR_STAND)) {
                    if (!(e instanceof ArmorStand)) continue;
                    ArmorStand stand = (ArmorStand)e;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new FlyingInit(stand).run(), 3L);
                        ItemStack box = stand.getEquipment().getHelmet();
                        ItemDisplay display = VehicleUtility.getItemDisplay(player, box, switch (box.getType()) {
                            case Material.ENDER_PEARL -> 1.5f;
                            case Material.GRAY_STAINED_GLASS_PANE -> 1.66f;
                            default -> 1.75f;
                        });
                        int animation = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new InterpolatedAnimation(display, 40), 5L, 40L);
                        int sound = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> TARDISSounds.playTARDISSound(player.getLocation(), "time_rotor_flying", 4.0f), 5L, 33L);
                        player.getPersistentDataContainer().set(this.plugin.getLoopKey(), PersistentDataType.INTEGER, (Object)sound);
                        stand.addPassenger((Entity)player);
                        TARDISArmourStand tas = (TARDISArmourStand)((CraftArmorStand)stand).getHandle();
                        tas.setPlayer(player);
                        tas.setStationary(false);
                        player.setInvulnerable(true);
                        player.setAllowFlight(true);
                        player.setFlying(true);
                        current.getBlock().getRelative(BlockFace.UP, 2).setBlockData(TARDISConstants.AIR);
                        this.plugin.getTrackerKeeper().getFlyingReturnLocation().put(uuid, new FlightReturnData(id, interior, sound, animation, stand.getUniqueId(), display.getUniqueId()));
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.setGravity(true), 1L);
                        Interaction interaction = TARDISDisplayItemUtils.getInteraction(current);
                        if (interaction != null) {
                            interaction.remove();
                        }
                    }, 5L);
                    break;
                }
            }, 3L);
        }, 5L);
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        tid.put("police_box", 1);
        ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, tid, true);
        if (rsb.resultSet()) {
            rsb.getData().forEach(rb -> TARDISBlockSetters.setBlock(rb.getLocation(), rb.getBlockData()));
        }
    }
}

