/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.display.TARDISDisplayType;
import me.eccentric_nz.TARDIS.flight.FlightVisibility;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISHotbarListener
implements Listener {
    private final TARDIS plugin;

    public TARDISHotbarListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSelectTARDISItem(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        ItemStack is = inv.getItem(event.getNewSlot());
        if (is != null) {
            if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) {
                ItemMeta im = is.getItemMeta();
                if (im.getPersistentDataContainer().has(this.plugin.getOldBlockKey(), PersistentDataType.INTEGER)) {
                    int which = (Integer)im.getPersistentDataContainer().get(this.plugin.getOldBlockKey(), PersistentDataType.INTEGER);
                    im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)which);
                    is.setItemMeta(im);
                }
                if (is.getType().equals((Object)Material.COMPASS) && ComponentUtils.endsWith(im.displayName(), "TARDIS Locator")) {
                    ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                    if (rs.fromUUID(player.getUniqueId().toString())) {
                        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, rs.getTardisId());
                        if (!rsc.resultSet()) {
                            return;
                        }
                        player.setCompassTarget(rsc.getCurrent().location());
                        this.plugin.getTrackerKeeper().getDisplay().put(player.getUniqueId(), TARDISDisplayType.LOCATOR);
                        this.plugin.getTrackerKeeper().getLocators().put(player.getUniqueId(), rsc.getCurrent().location());
                    }
                } else {
                    player.setCompassTarget(player.getWorld().getSpawnLocation());
                    if (this.plugin.getTrackerKeeper().getDisplay().containsKey(player.getUniqueId()) && this.plugin.getTrackerKeeper().getDisplay().get(player.getUniqueId()) == TARDISDisplayType.LOCATOR) {
                        this.plugin.getTrackerKeeper().getDisplay().remove(player.getUniqueId());
                        this.plugin.getTrackerKeeper().getLocators().remove(player.getUniqueId());
                    }
                }
            } else if (this.plugin.getTrackerKeeper().getDisplay().containsKey(player.getUniqueId()) && this.plugin.getTrackerKeeper().getDisplay().get(player.getUniqueId()) == TARDISDisplayType.LOCATOR) {
                this.plugin.getTrackerKeeper().getDisplay().remove(player.getUniqueId());
                this.plugin.getTrackerKeeper().getLocators().remove(player.getUniqueId());
            }
            if (!this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(player.getUniqueId())) return;
            switch (is.getType()) {
                case GLASS_BOTTLE: {
                    Entity as = player.getVehicle();
                    if (!(as instanceof ArmorStand)) return;
                    ArmorStand stand = (ArmorStand)as;
                    new FlightVisibility(this.plugin).hide(stand, player);
                    return;
                }
                case ARROW: {
                    return;
                }
                default: {
                    if (!this.plugin.getTrackerKeeper().getHiddenFlight().containsKey(player.getUniqueId())) return;
                    new FlightVisibility(this.plugin).show(player);
                    return;
                }
            }
        } else if (this.plugin.getTrackerKeeper().getHiddenFlight().containsKey(player.getUniqueId())) {
            new FlightVisibility(this.plugin).show(player);
            return;
        } else {
            if (!this.plugin.getTrackerKeeper().getDisplay().containsKey(player.getUniqueId()) || this.plugin.getTrackerKeeper().getDisplay().get(player.getUniqueId()) != TARDISDisplayType.LOCATOR) return;
            this.plugin.getTrackerKeeper().getDisplay().remove(player.getUniqueId());
            this.plugin.getTrackerKeeper().getLocators().remove(player.getUniqueId());
        }
    }
}

