/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic;

import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;

public class ResultSetArchive {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String prefix;
    private Archive archive;

    public ResultSetArchive(TARDIS plugin, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block24: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "archive" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        TardisLight light;
                        try {
                            light = TardisLight.valueOf(rs.getString("lights"));
                        }
                        catch (IllegalArgumentException e) {
                            light = TardisLight.LAMP;
                        }
                        this.archive = new Archive(UUID.fromString(rs.getString("uuid")), rs.getString("name"), rs.getString("console_size"), rs.getBoolean("beacon"), light, rs.getInt("use"), rs.getInt("y"), JsonParser.parseString((String)rs.getString("data")).getAsJsonObject(), rs.getString("description"));
                    }
                    break block24;
                }
                boolean light = false;
                return light;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for archive! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing archive! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Archive getArchive() {
        return this.archive;
    }
}

