/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.judoon;

import java.util.Collection;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.judoon.JudoonEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WaterChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class JudoonRunnable
implements Runnable {
    private final TARDIS plugin;

    public JudoonRunnable(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("judoon.worlds." + name) > 0) {
                int galactic = 0;
                Collection police = w.getEntitiesByClass(Husk.class);
                for (Husk h : police) {
                    PersistentDataContainer pdc = h.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID)) continue;
                    ++galactic;
                }
                if (galactic < this.plugin.getMonstersConfig().getInt("judoon.worlds." + name)) {
                    this.spawnJudoon((World)w);
                }
            }
        });
    }

    private void spawnJudoon(World world) {
        int z;
        int y;
        Chunk c;
        int x;
        Location l;
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0 && WaterChecker.isNotWater(l = new Location(world, (double)(x = (c = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)]).getX() * 16 + TARDISConstants.RANDOM.nextInt(16)), (double)((y = world.getHighestBlockYAt(x, z = c.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16))) + 1), (double)z))) {
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            LivingEntity husk = (LivingEntity)new MonsterSpawner().createFollower(l, new Follower(UUID.randomUUID(), TARDISWeepingAngels.UNCLAIMED, Monster.JUDOON)).getBukkitEntity();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                JudoonEquipment.set(null, husk, false);
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)husk, EntityType.HUSK, Monster.JUDOON, l));
            }, 2L);
        }
    }
}

